/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.riot.system;

import org.apache.jena.riot.system.FastAbbreviatingPrefixMap;
import org.apache.jena.riot.system.PrefixMap;
import org.apache.jena.riot.system.PrefixMapStd;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class TestAbbreviationPerformance {
    @BeforeClass
    public static void beforeClass() {
        int N = 1000;
        PrefixMapStd normal = new PrefixMapStd();
        TestAbbreviationPerformance.populate((PrefixMap)normal, N);
        FastAbbreviatingPrefixMap fast = new FastAbbreviatingPrefixMap();
        TestAbbreviationPerformance.populate((PrefixMap)fast, N);
        for (int i = 1; i <= N; ++i) {
            String input = "http://example/ns" + i + "#x";
            String expected = "ns" + i + ":x";
            TestAbbreviationPerformance.run((PrefixMap)normal, input, expected, 1000);
            TestAbbreviationPerformance.run((PrefixMap)fast, input, expected, 1000);
        }
    }

    private void test_amalgamated_performance(PrefixMapStd normal, FastAbbreviatingPrefixMap fast, int namespaces, boolean fastShouldWin) {
        long nPerf = 0L;
        long fPerf = 0L;
        for (int i = 1; i <= namespaces; ++i) {
            String input = "http://example/ns" + i + "#x";
            String expected = "ns" + i + ":x";
            nPerf += TestAbbreviationPerformance.run((PrefixMap)normal, input, expected, 1000);
            fPerf += TestAbbreviationPerformance.run((PrefixMap)fast, input, expected, 1000);
        }
        if (fastShouldWin) {
            if (fPerf > nPerf) {
                Assert.fail((String)"Expected FastAbbreviatingPrefixMap to outperform PrefixMap");
            }
        } else if (nPerf > fPerf) {
            Assert.fail((String)"Expected PrefixMap to outperform FastAbbreviatingPrefixMap");
        }
    }

    private static long run(PrefixMap pmap, String input, String expected, int runs) {
        long start = System.nanoTime();
        for (int i = 1; i <= runs; ++i) {
            String x = pmap.abbreviate(input);
            Assert.assertEquals((Object)expected, (Object)x);
        }
        return System.nanoTime() - start;
    }

    private static void populate(PrefixMap pmap, int count) {
        for (int i = 1; i <= count; ++i) {
            pmap.add("ns" + i, "http://example/ns" + i + "#");
        }
    }

    @Test
    public void prefixMap_abbrev_performance_01() {
        PrefixMapStd pmap = new PrefixMapStd();
        TestAbbreviationPerformance.populate((PrefixMap)pmap, 1);
        FastAbbreviatingPrefixMap fmap = new FastAbbreviatingPrefixMap();
        TestAbbreviationPerformance.populate((PrefixMap)fmap, 1);
        this.test_amalgamated_performance(pmap, fmap, 1, false);
    }

    @Test
    public void prefixMap_abbrev_performance_03() {
        PrefixMapStd pmap = new PrefixMapStd();
        TestAbbreviationPerformance.populate((PrefixMap)pmap, 40);
        FastAbbreviatingPrefixMap fmap = new FastAbbreviatingPrefixMap();
        TestAbbreviationPerformance.populate((PrefixMap)fmap, 40);
        this.test_amalgamated_performance(pmap, fmap, 40, true);
    }

    @Test
    public void prefixMap_abbrev_performance_04() {
        PrefixMapStd pmap = new PrefixMapStd();
        TestAbbreviationPerformance.populate((PrefixMap)pmap, 100);
        FastAbbreviatingPrefixMap fmap = new FastAbbreviatingPrefixMap();
        TestAbbreviationPerformance.populate((PrefixMap)fmap, 100);
        this.test_amalgamated_performance(pmap, fmap, 100, true);
    }
}

