/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.riot.system;

import com.hp.hpl.jena.rdf.model.impl.RDFWriterFImpl;
import com.hp.hpl.jena.rdfxml.xmloutput.impl.Abbreviated;
import com.hp.hpl.jena.rdfxml.xmloutput.impl.Basic;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.jena.riot.IO_Jena;
import org.apache.jena.riot.adapters.JenaReadersWriters;
import org.apache.jena.riot.system.IO_JenaWriters;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class TestIO_JenaWriters {
    @BeforeClass
    public static void beforeClass() {
    }

    @AfterClass
    public static void afterClass() {
        IO_Jena.wireIntoJena();
    }

    @Test
    public void testWireIntoJena() throws Exception {
        IO_JenaWriters.wireIntoJena();
        RDFWriterFImpl writerF = new RDFWriterFImpl();
        Assert.assertEquals(Basic.class, writerF.getWriter().getClass());
        Assert.assertEquals(Basic.class, writerF.getWriter("RDF/XML").getClass());
        Assert.assertEquals(Abbreviated.class, writerF.getWriter("RDF/XML-ABBREV").getClass());
        Assert.assertEquals(JenaReadersWriters.RDFWriterRIOT_NTriples.class, writerF.getWriter("N-TRIPLE").getClass());
        Assert.assertEquals(JenaReadersWriters.RDFWriterRIOT_NTriples.class, writerF.getWriter("N-Triples").getClass());
        Assert.assertEquals(JenaReadersWriters.RDFWriterRIOT_NTriples.class, writerF.getWriter("N-TRIPLE").getClass());
        Assert.assertEquals(JenaReadersWriters.RDFWriterRIOT_NTriples.class, writerF.getWriter("NT").getClass());
        Assert.assertEquals(JenaReadersWriters.RDFWriterRIOT_N3.class, writerF.getWriter("N3").getClass());
        Assert.assertEquals(JenaReadersWriters.RDFWriterRIOT_N3_PP.class, writerF.getWriter("N3-PP").getClass());
        Assert.assertEquals(JenaReadersWriters.RDFWriterRIOT_N3Plain.class, writerF.getWriter("N3-PLAIN").getClass());
        Assert.assertEquals(JenaReadersWriters.RDFWriterRIOT_N3Triples.class, writerF.getWriter("N3-TRIPLES").getClass());
        Assert.assertEquals(JenaReadersWriters.RDFWriterRIOT_N3TriplesAlt.class, writerF.getWriter("N3-TRIPLE").getClass());
        Assert.assertEquals(JenaReadersWriters.RDFWriterRIOT_Turtle.class, writerF.getWriter("TURTLE").getClass());
        Assert.assertEquals(JenaReadersWriters.RDFWriterRIOT_Turtle1.class, writerF.getWriter("Turtle").getClass());
        Assert.assertEquals(JenaReadersWriters.RDFWriterRIOT_Turtle2.class, writerF.getWriter("TTL").getClass());
        Assert.assertEquals(JenaReadersWriters.RDFWriterRIOT_RDFJSON.class, writerF.getWriter("RDF/JSON").getClass());
        Assert.assertEquals(JenaReadersWriters.RDFWriterRIOT_RDFJSON.class, writerF.getWriter("RDFJSON").getClass());
    }

    @Test
    public void testResetJena() throws Exception {
        IO_JenaWriters.wireIntoJena();
        IO_JenaWriters.resetJena();
        RDFWriterFImplExposingProtected writerF = new RDFWriterFImplExposingProtected();
        Map<String, String> defaults = writerF.defaultWriters();
        Assert.assertFalse((boolean)defaults.isEmpty());
        for (String lang : defaults.keySet()) {
            Assert.assertEquals((Object)defaults.get(lang), (Object)writerF.getLangToClassName().get(lang));
            Assert.assertEquals((Object)defaults.get(lang), (Object)writerF.getWriter(lang).getClass().getName());
        }
        Assert.assertEquals((Object)"", (Object)writerF.getLangToClassName().get("NT"));
        Assert.assertEquals((Object)"", (Object)writerF.getLangToClassName().get("RDF/JSON"));
        Assert.assertEquals((Object)"", (Object)writerF.getLangToClassName().get("RDFJSON"));
        IO_JenaWriters.wireIntoJena();
    }

    private final class RDFWriterFImplExposingProtected
    extends RDFWriterFImpl {
        private RDFWriterFImplExposingProtected() {
        }

        public Map<String, String> defaultWriters() {
            LinkedHashMap<String, String> defaults = new LinkedHashMap<String, String>();
            for (int i = 0; i < LANGS.length; ++i) {
                defaults.put(LANGS[i], DEFAULTWRITERS[i]);
            }
            return defaults;
        }

        public Properties getLangToClassName() {
            return langToClassName;
        }
    }
}

