/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.web;

import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.GraphUtil;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.NodeFactory;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.sparql.graph.GraphFactory;
import com.hp.hpl.jena.sparql.sse.SSE;
import java.io.OutputStream;
import org.apache.jena.atlas.junit.BaseTest;
import org.apache.jena.riot.Lang;
import org.apache.jena.riot.RDFDataMgr;
import org.apache.jena.web.DatasetGraphAccessor;
import org.junit.Test;

public abstract class AbstractTestDatasetGraphAccessor
extends BaseTest {
    protected static final String gn1 = "http://graph/1";
    protected static final String gn2 = "http://graph/2";
    protected static final String gn99 = "http://graph/99";
    protected static final Node n1 = NodeFactory.createURI((String)"http://graph/1");
    protected static final Node n2 = NodeFactory.createURI((String)"http://graph/2");
    protected static final Node n99 = NodeFactory.createURI((String)"http://graph/99");
    protected static final Graph graph1 = SSE.parseGraph((String)"(base <http://example/> (graph (<x> <p> 1)))");
    protected static final Graph graph2 = SSE.parseGraph((String)"(base <http://example/> (graph (<x> <p> 2)))");
    protected static final Model model1 = ModelFactory.createModelForGraph((Graph)graph1);
    protected static final Model model2 = ModelFactory.createModelForGraph((Graph)graph2);

    protected abstract DatasetGraphAccessor getDatasetUpdater();

    private static void assertNullOrEmpty(Graph graph) {
        if (graph == null) {
            return;
        }
        if (!graph.isEmpty()) {
            System.out.println("----");
            RDFDataMgr.write((OutputStream)System.out, (Graph)graph, (Lang)Lang.TTL);
        }
        AbstractTestDatasetGraphAccessor.assertTrue((boolean)graph.isEmpty());
    }

    @Test
    public void get_01() {
        DatasetGraphAccessor updater = this.getDatasetUpdater();
        Graph graph = updater.httpGet();
        AbstractTestDatasetGraphAccessor.assertNullOrEmpty(graph);
        Graph graph2 = updater.httpGet(n1);
    }

    @Test
    public void get_02() {
        DatasetGraphAccessor updater = this.getDatasetUpdater();
        Graph graph = updater.httpGet(n1);
        AbstractTestDatasetGraphAccessor.assertNullOrEmpty(graph);
    }

    @Test
    public void put_01() {
        DatasetGraphAccessor updater = this.getDatasetUpdater();
        updater.httpPut(graph1);
        Graph graph = updater.httpGet();
        AbstractTestDatasetGraphAccessor.assertNotNull((String)"Graph is null", (Object)graph);
        AbstractTestDatasetGraphAccessor.assertTrue((boolean)graph.isIsomorphicWith(graph1));
    }

    @Test
    public void put_02() {
        DatasetGraphAccessor updater = this.getDatasetUpdater();
        updater.httpPut(n1, graph1);
        Graph graph = updater.httpGet();
        AbstractTestDatasetGraphAccessor.assertNullOrEmpty(graph);
        graph = updater.httpGet(n1);
        AbstractTestDatasetGraphAccessor.assertNotNull((String)"Graph is null", (Object)graph);
        AbstractTestDatasetGraphAccessor.assertTrue((boolean)graph.isIsomorphicWith(graph1));
    }

    @Test
    public void post_01() {
        DatasetGraphAccessor updater = this.getDatasetUpdater();
        updater.httpPost(graph1);
        updater.httpPost(graph2);
        Graph graph = updater.httpGet();
        Graph graph3 = GraphFactory.createDefaultGraph();
        GraphUtil.addInto((Graph)graph3, (Graph)graph1);
        GraphUtil.addInto((Graph)graph3, (Graph)graph2);
        AbstractTestDatasetGraphAccessor.assertTrue((boolean)graph.isIsomorphicWith(graph3));
        AbstractTestDatasetGraphAccessor.assertFalse((boolean)graph.isIsomorphicWith(graph1));
        AbstractTestDatasetGraphAccessor.assertFalse((boolean)graph.isIsomorphicWith(graph2));
    }

    @Test
    public void post_02() {
        DatasetGraphAccessor updater = this.getDatasetUpdater();
        updater.httpPost(n1, graph1);
        updater.httpPost(n1, graph2);
        Graph graph = updater.httpGet(n1);
        Graph graph3 = GraphFactory.createDefaultGraph();
        GraphUtil.addInto((Graph)graph3, (Graph)graph1);
        GraphUtil.addInto((Graph)graph3, (Graph)graph2);
        AbstractTestDatasetGraphAccessor.assertTrue((boolean)graph.isIsomorphicWith(graph3));
        AbstractTestDatasetGraphAccessor.assertFalse((boolean)graph.isIsomorphicWith(graph1));
        AbstractTestDatasetGraphAccessor.assertFalse((boolean)graph.isIsomorphicWith(graph2));
        graph = updater.httpGet();
        AbstractTestDatasetGraphAccessor.assertFalse((boolean)graph.isIsomorphicWith(graph3));
    }

    @Test
    public void delete_01() {
        DatasetGraphAccessor updater = this.getDatasetUpdater();
        updater.httpDelete();
        Graph graph = updater.httpGet();
        AbstractTestDatasetGraphAccessor.assertTrue((boolean)graph.isEmpty());
        updater.httpPut(graph1);
        graph = updater.httpGet();
        AbstractTestDatasetGraphAccessor.assertFalse((boolean)graph.isEmpty());
        updater.httpDelete();
        graph = updater.httpGet();
        AbstractTestDatasetGraphAccessor.assertTrue((boolean)graph.isEmpty());
    }

    @Test
    public void delete_02() {
        DatasetGraphAccessor updater = this.getDatasetUpdater();
        Graph graph = updater.httpGet(n1);
        AbstractTestDatasetGraphAccessor.assertNullOrEmpty(graph);
        updater.httpPut(graph2);
        updater.httpPut(n1, graph1);
        updater.httpDelete();
        graph = updater.httpGet();
        AbstractTestDatasetGraphAccessor.assertTrue((boolean)graph.isEmpty());
        updater.httpPut(graph2);
        graph = updater.httpGet(n1);
        AbstractTestDatasetGraphAccessor.assertFalse((boolean)graph.isEmpty());
        updater.httpDelete(n1);
        graph = updater.httpGet(n1);
        AbstractTestDatasetGraphAccessor.assertNullOrEmpty(graph);
        graph = updater.httpGet();
        AbstractTestDatasetGraphAccessor.assertFalse((boolean)graph.isEmpty());
    }
}

