/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.atlas.lib;

import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class AlarmClock {
    private ScheduledThreadPoolExecutor timer = new ScheduledThreadPoolExecutor(1);
    private static AlarmClock singleton = new AlarmClock();

    AlarmClock() {
    }

    public static AlarmClock get() {
        return singleton;
    }

    public void add(Runnable task, long delay) {
        if (task == null) {
            throw new IllegalArgumentException("Task is null");
        }
        this.timer.schedule(task, delay, TimeUnit.MILLISECONDS);
    }

    public void reset(Runnable task, long delay) {
        if (task == null) {
            throw new IllegalArgumentException("Task is null");
        }
        this.cancel(task);
        this.add(task, delay);
    }

    public void cancel(Runnable task) {
        if (task == null) {
            throw new IllegalArgumentException("Task is null");
        }
        this.timer.remove(task);
    }

    public void release() {
        this.timer.shutdownNow();
    }
}

