/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.riot;

import org.apache.jena.atlas.lib.Lib;
import org.apache.jena.atlas.web.ContentType;
import org.apache.jena.riot.Lang;
import org.apache.jena.riot.RDFLanguages;
import org.apache.jena.riot.resultset.ResultSetLang;

public class WebContent {
    public static final String contentTypeTurtle = "text/turtle";
    public static final ContentType ctTurtle = ContentType.create("text/turtle");
    public static final String contentTypeTurtleAlt1 = "application/turtle";
    public static final ContentType ctTurtleAlt1 = ContentType.create("application/turtle");
    public static final String contentTypeTurtleAlt2 = "application/x-turtle";
    public static final ContentType ctTurtleAlt2 = ContentType.create("application/x-turtle");
    public static final String contentTypeRDFXML = "application/rdf+xml";
    public static final ContentType ctRDFXML = ContentType.create("application/rdf+xml");
    public static final String contentTypeRDFJSON = "application/rdf+json";
    public static final ContentType ctRDFJSON;
    @Deprecated
    public static final String contentTypeRdfJson = "application/rdf+json";
    @Deprecated
    public static final ContentType ctRrdfJson;
    public static final String contentTypeJSONLD = "application/ld+json";
    public static final ContentType ctJSONLD;
    public static final String contentTypeTextPlain = "text/plain";
    public static final ContentType ctTextPlain;
    public static final String contentTypeNTriples = "application/n-triples";
    public static final ContentType ctNTriples;
    public static final String contentTypeNTriplesAlt = "text/plain";
    public static final ContentType ctNTriplesAlt;
    public static final String contentTypeXML = "application/xml";
    public static final ContentType ctXML;
    public static final String contentTypeXMLAlt = "text/xml";
    public static final ContentType ctXMLAlt;
    public static final String contentTypeTriG = "text/trig";
    public static final ContentType ctTriG;
    public static final String contentTypeNQuads = "application/n-quads";
    public static final ContentType ctNQuads;
    public static final String contentTypeTriGAlt1 = "application/x-trig";
    public static final ContentType ctTriGAlt1;
    public static final String contentTypeTriGAlt2 = "application/trig";
    public static final ContentType ctTriGAlt2;
    public static final String contentTypeRDFThrift = "application/rdf+thrift";
    public static final ContentType ctRDFTHRIFT;
    public static final String contentTypeNQuadsAlt1 = "text/n-quads";
    public static final ContentType ctNQuadsAlt1;
    public static final String contentTypeNQuadsAlt2 = "text/nquads";
    public static final ContentType ctNQuadsAlt2;
    public static final String contentTypeTriX = "application/trix";
    public static final ContentType ctTriX;
    public static final String contentTypeTriXxml = "application/trix+xml";
    public static final ContentType ctTriXxml;
    public static final String contentTypeOctets = "application/octet-stream";
    public static final ContentType ctOctets;
    public static final String contentTypeMultipartMixed = "multipart/mixed";
    public static final ContentType ctMultipartMixed;
    public static final String contentTypeMultipartFormData = "multipart/form-data";
    public static final ContentType ctMultipartFormData;
    public static final String contentTypeMultiAlt = "multipart/alternative";
    public static final ContentType ctMultiAlt;
    public static final String contentTypeN3 = "text/rdf+n3";
    public static final ContentType ctTypeN3;
    public static final String contentTypeN3Alt1 = "application/n3";
    public static final ContentType ctN3Alt1;
    public static final String contentTypeN3Alt2 = "text/n3";
    public static final ContentType ctN3Alt2;
    public static final String contentTypeResultsXML = "application/sparql-results+xml";
    public static final ContentType ctResultsXML;
    public static final String contentTypeResultsJSON = "application/sparql-results+json";
    public static final ContentType ctResultsJSON;
    public static final String contentTypeJSON = "application/json";
    public static final ContentType ctJSON;
    public static final String contentTypeResultsThrift = "application/sparql-results+thrift";
    public static final ContentType ctResultsThrift;
    public static final String contentTypeSPARQLQuery = "application/sparql-query";
    public static final ContentType ctSPARQLQuery;
    public static final String contentTypeSPARQLUpdate = "application/sparql-update";
    public static final ContentType ctSPARQLUpdate;
    public static final String contentTypeHTMLForm = "application/x-www-form-urlencoded";
    public static final ContentType ctHTMLForm;
    public static final String contentTypeTextCSV = "text/csv";
    public static final ContentType ctTextCSV;
    public static final String contentTypeTextTSV = "text/tab-separated-values";
    public static final ContentType ctTextTSV;
    public static final String contentTypeSSE = "text/sse";
    public static final ContentType ctSSE;
    public static final String charsetUTF8 = "utf-8";
    public static final String charsetASCII = "ascii";
    public static final String langRDFXML = "RDF/XML";
    public static final String langRDFXMLAbbrev = "RDF/XML-ABBREV";
    public static final String langNTriple = "N-TRIPLE";
    public static final String langNTriples = "N-TRIPLES";
    public static final String langN3 = "N3";
    public static final String langTurtle = "TURTLE";
    public static final String langTTL = "TTL";
    public static final String langRdfJson = "RDF/JSON";
    public static final String langNQuads = "NQUADS";
    public static final String langTriG = "TRIG";
    public static final String encodingUTF8 = "utf-8";
    private static final String defaultGraphAccept = "text/turtle,application/n-triples;q=0.9,application/ld+json;q=0.8,application/rdf+xml;q=0.7";
    public static final String defaultGraphAcceptHeader = "text/turtle,application/n-triples;q=0.9,application/ld+json;q=0.8,application/rdf+xml;q=0.7,*/*;q=0.3";
    private static final String defaultDatasetAccept = "application/trig,application/n-quads;q=0.9,application/ld+json;q=0.8";
    public static final String defaultDatasetAcceptHeader = "application/trig,application/n-quads;q=0.9,application/ld+json;q=0.8,*/*;q=0.3";
    public static final String defaultRDFAcceptHeader = "text/turtle,application/n-triples;q=0.9,application/rdf+xml;q=0.7,application/trig,application/n-quads;q=0.9,application/ld+json;q=0.8,*/*;q=0.5";

    public static String contentTypeCanonical(String contentType) {
        Lang lang = RDFLanguages.contentTypeToLang(contentType);
        if (lang == null) {
            return null;
        }
        return lang.getHeaderString();
    }

    public static boolean matchContentType(ContentType ct1, ContentType ct2) {
        if (ct1 == null || ct2 == null) {
            return false;
        }
        return WebContent.matchContentType(ct1.getContentTypeStr(), ct2.getContentTypeStr());
    }

    public static boolean matchContentType(String ct1, String ct2) {
        return Lib.equalsIgnoreCase((String)ct1, (String)ct2);
    }

    public static boolean isHtmlForm(ContentType ct) {
        if (ct == null) {
            return false;
        }
        return contentTypeHTMLForm.equalsIgnoreCase(ct.getContentTypeStr());
    }

    public static boolean isMultiPartForm(ContentType ct) {
        return contentTypeMultipartFormData.equalsIgnoreCase(ct.getContentTypeStr());
    }

    public static ContentType determineCT(String contentTypeStr, Lang hintLang, String target) {
        boolean isTextPlain = "text/plain".equals(contentTypeStr);
        if (contentTypeStr != null) {
            contentTypeStr = WebContent.contentTypeCanonical(contentTypeStr);
        }
        ContentType ct = null;
        if (!isTextPlain) {
            ContentType contentType = ct = contentTypeStr == null ? null : ContentType.create(contentTypeStr);
        }
        if (ct == null && hintLang != null) {
            ct = hintLang.getContentType();
        }
        if (ct == null) {
            ct = RDFLanguages.guessContentType(target);
        }
        return ct;
    }

    public static Lang contentTypeToLangResultSet(String contentType) {
        if (contentType == null) {
            return null;
        }
        if (contentType.equals(contentTypeXML)) {
            return ResultSetLang.SPARQLResultSetXML;
        }
        if (contentType.equals(contentTypeJSON)) {
            return ResultSetLang.SPARQLResultSetJSON;
        }
        Lang lang = RDFLanguages.contentTypeToLang(contentType);
        return lang;
    }

    static {
        ctRrdfJson = ctRDFJSON = ContentType.create("application/rdf+json");
        ctJSONLD = ContentType.create(contentTypeJSONLD);
        ctTextPlain = ContentType.create("text/plain");
        ctNTriples = ContentType.create(contentTypeNTriples);
        ctNTriplesAlt = ContentType.create("text/plain");
        ctXML = ContentType.create(contentTypeXML);
        ctXMLAlt = ContentType.create(contentTypeXMLAlt);
        ctTriG = ContentType.create(contentTypeTriG);
        ctNQuads = ContentType.create(contentTypeNQuads);
        ctTriGAlt1 = ContentType.create(contentTypeTriGAlt1);
        ctTriGAlt2 = ContentType.create(contentTypeTriGAlt2);
        ctRDFTHRIFT = ContentType.create(contentTypeRDFThrift);
        ctNQuadsAlt1 = ContentType.create(contentTypeNQuadsAlt1);
        ctNQuadsAlt2 = ContentType.create(contentTypeNQuadsAlt2);
        ctTriX = ContentType.create(contentTypeTriX);
        ctTriXxml = ContentType.create(contentTypeTriXxml);
        ctOctets = ContentType.create(contentTypeOctets);
        ctMultipartMixed = ContentType.create(contentTypeMultipartMixed);
        ctMultipartFormData = ContentType.create(contentTypeMultipartFormData);
        ctMultiAlt = ContentType.create(contentTypeMultiAlt);
        ctTypeN3 = ContentType.create(contentTypeN3);
        ctN3Alt1 = ContentType.create(contentTypeN3Alt1);
        ctN3Alt2 = ContentType.create(contentTypeN3Alt2);
        ctResultsXML = ContentType.create(contentTypeResultsXML);
        ctResultsJSON = ContentType.create(contentTypeResultsJSON);
        ctJSON = ContentType.create(contentTypeJSON);
        ctResultsThrift = ContentType.create(contentTypeResultsThrift);
        ctSPARQLQuery = ContentType.create(contentTypeSPARQLQuery);
        ctSPARQLUpdate = ContentType.create(contentTypeSPARQLUpdate);
        ctHTMLForm = ContentType.create(contentTypeHTMLForm);
        ctTextCSV = ContentType.create(contentTypeTextCSV);
        ctTextTSV = ContentType.create(contentTypeTextTSV);
        ctSSE = ContentType.create(contentTypeSSE);
    }
}

