/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.riot.out;

import java.io.OutputStream;
import org.apache.jena.atlas.io.AWriter;
import org.apache.jena.atlas.io.IO;
import org.apache.jena.atlas.lib.Sink;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.riot.out.NodeFormatter;
import org.apache.jena.riot.out.NodeFormatterNT;
import org.apache.jena.riot.out.NodeToLabel;
import org.apache.jena.riot.system.Prologue;

public class SinkTripleOutput
implements Sink<Triple> {
    private Prologue prologue = null;
    private final AWriter out;
    private NodeToLabel labelPolicy = null;
    private NodeFormatter nodeFmt = new NodeFormatterNT();

    public SinkTripleOutput(OutputStream outs, Prologue prologue, NodeToLabel labels) {
        this.out = IO.wrapUTF8((OutputStream)outs);
        this.setPrologue(prologue);
        this.setLabelPolicy(labels);
    }

    public void setPrologue(Prologue prologue) {
        this.prologue = prologue;
    }

    public void setLabelPolicy(NodeToLabel labels) {
        this.labelPolicy = labels;
    }

    public void send(Triple triple) {
        Node s = triple.getSubject();
        Node p = triple.getPredicate();
        Node o = triple.getObject();
        this.nodeFmt.format(this.out, s);
        this.out.print(" ");
        this.nodeFmt.format(this.out, p);
        this.out.print(" ");
        this.nodeFmt.format(this.out, o);
        this.out.print(" .\n");
    }

    public void flush() {
        IO.flush((AWriter)this.out);
    }

    public void close() {
        IO.flush((AWriter)this.out);
    }
}

