/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.ext.xerces_regex;

import java.io.Serializable;
import java.util.Hashtable;
import java.util.Vector;
import org.apache.jena.ext.xerces_regex.REUtil;
import org.apache.jena.ext.xerces_regex.RangeToken;

class RX_Token
implements Serializable {
    private static final long serialVersionUID = 8484976002585487481L;
    static final boolean COUNTTOKENS = true;
    static int tokens = 0;
    static final int CHAR = 0;
    static final int DOT = 11;
    static final int CONCAT = 1;
    static final int UNION = 2;
    static final int CLOSURE = 3;
    static final int RANGE = 4;
    static final int NRANGE = 5;
    static final int PAREN = 6;
    static final int EMPTY = 7;
    static final int ANCHOR = 8;
    static final int NONGREEDYCLOSURE = 9;
    static final int STRING = 10;
    static final int BACKREFERENCE = 12;
    static final int LOOKAHEAD = 20;
    static final int NEGATIVELOOKAHEAD = 21;
    static final int LOOKBEHIND = 22;
    static final int NEGATIVELOOKBEHIND = 23;
    static final int INDEPENDENT = 24;
    static final int MODIFIERGROUP = 25;
    static final int CONDITION = 26;
    static final int UTF16_MAX = 0x10FFFF;
    final int type;
    static RX_Token token_dot;
    static RX_Token token_0to9;
    static RX_Token token_wordchars;
    static RX_Token token_not_0to9;
    static RX_Token token_not_wordchars;
    static RX_Token token_spaces;
    static RX_Token token_not_spaces;
    static RX_Token token_empty;
    static RX_Token token_linebeginning;
    static RX_Token token_linebeginning2;
    static RX_Token token_lineend;
    static RX_Token token_stringbeginning;
    static RX_Token token_stringend;
    static RX_Token token_stringend2;
    static RX_Token token_wordedge;
    static RX_Token token_not_wordedge;
    static RX_Token token_wordbeginning;
    static RX_Token token_wordend;
    static final int FC_CONTINUE = 0;
    static final int FC_TERMINAL = 1;
    static final int FC_ANY = 2;
    private static final Hashtable categories;
    private static final Hashtable categories2;
    private static final String[] categoryNames;
    static final int CHAR_INIT_QUOTE = 29;
    static final int CHAR_FINAL_QUOTE = 30;
    static final int CHAR_LETTER = 31;
    static final int CHAR_MARK = 32;
    static final int CHAR_NUMBER = 33;
    static final int CHAR_SEPARATOR = 34;
    static final int CHAR_OTHER = 35;
    static final int CHAR_PUNCTUATION = 36;
    static final int CHAR_SYMBOL = 37;
    private static final String[] blockNames;
    static final String blockRanges = "\u0000\u007f\u0080\u00ff\u0100\u017f\u0180\u024f\u0250\u02af\u02b0\u02ff\u0300\u036f\u0370\u03ff\u0400\u04ff\u0530\u058f\u0590\u05ff\u0600\u06ff\u0700\u074f\u0780\u07bf\u0900\u097f\u0980\u09ff\u0a00\u0a7f\u0a80\u0aff\u0b00\u0b7f\u0b80\u0bff\u0c00\u0c7f\u0c80\u0cff\u0d00\u0d7f\u0d80\u0dff\u0e00\u0e7f\u0e80\u0eff\u0f00\u0fff\u1000\u109f\u10a0\u10ff\u1100\u11ff\u1200\u137f\u13a0\u13ff\u1400\u167f\u1680\u169f\u16a0\u16ff\u1780\u17ff\u1800\u18af\u1e00\u1eff\u1f00\u1fff\u2000\u206f\u2070\u209f\u20a0\u20cf\u20d0\u20ff\u2100\u214f\u2150\u218f\u2190\u21ff\u2200\u22ff\u2300\u23ff\u2400\u243f\u2440\u245f\u2460\u24ff\u2500\u257f\u2580\u259f\u25a0\u25ff\u2600\u26ff\u2700\u27bf\u2800\u28ff\u2e80\u2eff\u2f00\u2fdf\u2ff0\u2fff\u3000\u303f\u3040\u309f\u30a0\u30ff\u3100\u312f\u3130\u318f\u3190\u319f\u31a0\u31bf\u3200\u32ff\u3300\u33ff\u3400\u4db5\u4e00\u9fff\ua000\ua48f\ua490\ua4cf\uac00\ud7a3\ue000\uf8ff\uf900\ufaff\ufb00\ufb4f\ufb50\ufdff\ufe20\ufe2f\ufe30\ufe4f\ufe50\ufe6f\ufe70\ufefe\ufeff\ufeff\uff00\uffef";
    static final int[] nonBMPBlockRanges;
    private static final int NONBMP_BLOCK_START = 84;
    static Hashtable nonxs;
    static final String viramaString = "\u094d\u09cd\u0a4d\u0acd\u0b4d\u0bcd\u0c4d\u0ccd\u0d4d\u0e3a\u0f84";
    private static RX_Token token_grapheme;
    private static RX_Token token_ccs;

    static ParenToken createLook(int type, RX_Token child) {
        ++tokens;
        return new ParenToken(type, child, 0);
    }

    static ParenToken createParen(RX_Token child, int pnumber) {
        ++tokens;
        return new ParenToken(6, child, pnumber);
    }

    static ClosureToken createClosure(RX_Token tok) {
        ++tokens;
        return new ClosureToken(3, tok);
    }

    static ClosureToken createNGClosure(RX_Token tok) {
        ++tokens;
        return new ClosureToken(9, tok);
    }

    static ConcatToken createConcat(RX_Token tok1, RX_Token tok2) {
        ++tokens;
        return new ConcatToken(tok1, tok2);
    }

    static UnionToken createConcat() {
        ++tokens;
        return new UnionToken(1);
    }

    static UnionToken createUnion() {
        ++tokens;
        return new UnionToken(2);
    }

    static RX_Token createEmpty() {
        return token_empty;
    }

    static RangeToken createRange() {
        ++tokens;
        return new RangeToken(4);
    }

    static RangeToken createNRange() {
        ++tokens;
        return new RangeToken(5);
    }

    static CharToken createChar(int ch) {
        ++tokens;
        return new CharToken(0, ch);
    }

    private static CharToken createAnchor(int ch) {
        ++tokens;
        return new CharToken(8, ch);
    }

    static StringToken createBackReference(int refno) {
        ++tokens;
        return new StringToken(12, null, refno);
    }

    static StringToken createString(String str2) {
        ++tokens;
        return new StringToken(10, str2, 0);
    }

    static ModifierToken createModifierGroup(RX_Token child, int add, int mask) {
        ++tokens;
        return new ModifierToken(child, add, mask);
    }

    static ConditionToken createCondition(int refno, RX_Token condition, RX_Token yespat, RX_Token nopat) {
        ++tokens;
        return new ConditionToken(refno, condition, yespat, nopat);
    }

    protected RX_Token(int type) {
        this.type = type;
    }

    int size() {
        return 0;
    }

    RX_Token getChild(int index) {
        return null;
    }

    void addChild(RX_Token tok) {
        throw new RuntimeException("Not supported.");
    }

    protected void addRange(int start, int end) {
        throw new RuntimeException("Not supported.");
    }

    protected void sortRanges() {
        throw new RuntimeException("Not supported.");
    }

    protected void compactRanges() {
        throw new RuntimeException("Not supported.");
    }

    protected void mergeRanges(RX_Token tok) {
        throw new RuntimeException("Not supported.");
    }

    protected void subtractRanges(RX_Token tok) {
        throw new RuntimeException("Not supported.");
    }

    protected void intersectRanges(RX_Token tok) {
        throw new RuntimeException("Not supported.");
    }

    static RX_Token complementRanges(RX_Token tok) {
        return RangeToken.complementRanges(tok);
    }

    void setMin(int min2) {
    }

    void setMax(int max2) {
    }

    int getMin() {
        return -1;
    }

    int getMax() {
        return -1;
    }

    int getReferenceNumber() {
        return 0;
    }

    String getString() {
        return null;
    }

    int getParenNumber() {
        return 0;
    }

    int getChar() {
        return -1;
    }

    public String toString() {
        return this.toString(0);
    }

    public String toString(int options) {
        return this.type == 11 ? "." : "";
    }

    final int getMinLength() {
        switch (this.type) {
            case 1: {
                int sum = 0;
                for (int i = 0; i < this.size(); ++i) {
                    sum += this.getChild(i).getMinLength();
                }
                return sum;
            }
            case 2: 
            case 26: {
                if (this.size() == 0) {
                    return 0;
                }
                int ret = this.getChild(0).getMinLength();
                for (int i = 1; i < this.size(); ++i) {
                    int min2 = this.getChild(i).getMinLength();
                    if (min2 >= ret) continue;
                    ret = min2;
                }
                return ret;
            }
            case 3: 
            case 9: {
                if (this.getMin() >= 0) {
                    return this.getMin() * this.getChild(0).getMinLength();
                }
                return 0;
            }
            case 7: 
            case 8: {
                return 0;
            }
            case 0: 
            case 4: 
            case 5: 
            case 11: {
                return 1;
            }
            case 6: 
            case 24: 
            case 25: {
                return this.getChild(0).getMinLength();
            }
            case 12: {
                return 0;
            }
            case 10: {
                return this.getString().length();
            }
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                return 0;
            }
        }
        throw new RuntimeException("Token#getMinLength(): Invalid Type: " + this.type);
    }

    final int getMaxLength() {
        switch (this.type) {
            case 1: {
                int sum = 0;
                for (int i = 0; i < this.size(); ++i) {
                    int d = this.getChild(i).getMaxLength();
                    if (d < 0) {
                        return -1;
                    }
                    sum += d;
                }
                return sum;
            }
            case 2: 
            case 26: {
                if (this.size() == 0) {
                    return 0;
                }
                int ret = this.getChild(0).getMaxLength();
                for (int i = 1; ret >= 0 && i < this.size(); ++i) {
                    int max2 = this.getChild(i).getMaxLength();
                    if (max2 < 0) {
                        ret = -1;
                        break;
                    }
                    if (max2 <= ret) continue;
                    ret = max2;
                }
                return ret;
            }
            case 3: 
            case 9: {
                if (this.getMax() >= 0) {
                    return this.getMax() * this.getChild(0).getMaxLength();
                }
                return -1;
            }
            case 7: 
            case 8: {
                return 0;
            }
            case 0: {
                return 1;
            }
            case 4: 
            case 5: 
            case 11: {
                return 2;
            }
            case 6: 
            case 24: 
            case 25: {
                return this.getChild(0).getMaxLength();
            }
            case 12: {
                return -1;
            }
            case 10: {
                return this.getString().length();
            }
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                return 0;
            }
        }
        throw new RuntimeException("Token#getMaxLength(): Invalid Type: " + this.type);
    }

    private static final boolean isSet(int options, int flag) {
        return (options & flag) == flag;
    }

    final int analyzeFirstCharacter(RangeToken result, int options) {
        switch (this.type) {
            case 1: {
                int ret = 0;
                for (int i = 0; i < this.size() && (ret = this.getChild(i).analyzeFirstCharacter(result, options)) == 0; ++i) {
                }
                return ret;
            }
            case 2: {
                if (this.size() == 0) {
                    return 0;
                }
                int ret2 = 0;
                boolean hasEmpty = false;
                for (int i = 0; i < this.size() && (ret2 = this.getChild(i).analyzeFirstCharacter(result, options)) != 2; ++i) {
                    if (ret2 != 0) continue;
                    hasEmpty = true;
                }
                return hasEmpty ? 0 : ret2;
            }
            case 26: {
                int ret3 = this.getChild(0).analyzeFirstCharacter(result, options);
                if (this.size() == 1) {
                    return 0;
                }
                if (ret3 == 2) {
                    return ret3;
                }
                int ret4 = this.getChild(1).analyzeFirstCharacter(result, options);
                if (ret4 == 2) {
                    return ret4;
                }
                return ret3 == 0 || ret4 == 0 ? 0 : 1;
            }
            case 3: 
            case 9: {
                this.getChild(0).analyzeFirstCharacter(result, options);
                return 0;
            }
            case 7: 
            case 8: {
                return 0;
            }
            case 0: {
                int ch = this.getChar();
                result.addRange(ch, ch);
                if (ch < 65536 && RX_Token.isSet(options, 2)) {
                    ch = Character.toUpperCase((char)ch);
                    result.addRange(ch, ch);
                    ch = Character.toLowerCase((char)ch);
                    result.addRange(ch, ch);
                }
                return 1;
            }
            case 11: {
                return 2;
            }
            case 4: {
                result.mergeRanges(this);
                return 1;
            }
            case 5: {
                result.mergeRanges(RX_Token.complementRanges(this));
                return 1;
            }
            case 6: 
            case 24: {
                return this.getChild(0).analyzeFirstCharacter(result, options);
            }
            case 25: {
                options |= ((ModifierToken)this).getOptions();
                return this.getChild(0).analyzeFirstCharacter(result, options &= ~((ModifierToken)this).getOptionsMask());
            }
            case 12: {
                result.addRange(0, 0x10FFFF);
                return 2;
            }
            case 10: {
                char ch2;
                int cha = this.getString().charAt(0);
                if (REUtil.isHighSurrogate(cha) && this.getString().length() >= 2 && REUtil.isLowSurrogate(ch2 = this.getString().charAt(1))) {
                    cha = REUtil.composeFromSurrogates(cha, ch2);
                }
                result.addRange(cha, cha);
                if (cha < 65536 && RX_Token.isSet(options, 2)) {
                    cha = Character.toUpperCase((char)cha);
                    result.addRange(cha, cha);
                    cha = Character.toLowerCase((char)cha);
                    result.addRange(cha, cha);
                }
                return 1;
            }
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                return 0;
            }
        }
        throw new RuntimeException("Token#analyzeHeadCharacter(): Invalid Type: " + this.type);
    }

    private final boolean isShorterThan(RX_Token tok) {
        if (tok == null) {
            return false;
        }
        if (this.type != 10) {
            throw new RuntimeException("Internal Error: Illegal type: " + this.type);
        }
        int mylength = this.getString().length();
        if (tok.type != 10) {
            throw new RuntimeException("Internal Error: Illegal type: " + tok.type);
        }
        int otherlength = tok.getString().length();
        return mylength < otherlength;
    }

    final void findFixedString(FixedStringContainer container2, int options) {
        switch (this.type) {
            case 1: {
                RX_Token prevToken = null;
                int prevOptions = 0;
                for (int i = 0; i < this.size(); ++i) {
                    this.getChild(i).findFixedString(container2, options);
                    if (prevToken != null && !prevToken.isShorterThan(container2.token)) continue;
                    prevToken = container2.token;
                    prevOptions = container2.options;
                }
                container2.token = prevToken;
                container2.options = prevOptions;
                return;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 26: {
                container2.token = null;
                return;
            }
            case 0: {
                container2.token = null;
                return;
            }
            case 10: {
                container2.token = this;
                container2.options = options;
                return;
            }
            case 6: 
            case 24: {
                this.getChild(0).findFixedString(container2, options);
                return;
            }
            case 25: {
                options |= ((ModifierToken)this).getOptions();
                this.getChild(0).findFixedString(container2, options &= ~((ModifierToken)this).getOptionsMask());
                return;
            }
        }
        throw new RuntimeException("Token#findFixedString(): Invalid Type: " + this.type);
    }

    boolean match(int ch) {
        throw new RuntimeException("NFAArrow#match(): Internal error: " + this.type);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static RangeToken getRange(String name, boolean positive) {
        if (categories.size() == 0) {
            Hashtable hashtable = categories;
            synchronized (hashtable) {
                int i;
                RX_Token[] ranges = new RX_Token[categoryNames.length];
                for (int i2 = 0; i2 < ranges.length; ++i2) {
                    ranges[i2] = RX_Token.createRange();
                }
                for (i = 0; i < 65536; ++i) {
                    int type = Character.getType((char)i);
                    if (type == 21 || type == 22) {
                        if (i == 171 || i == 8216 || i == 8219 || i == 8220 || i == 8223 || i == 8249) {
                            type = 29;
                        }
                        if (i == 187 || i == 8217 || i == 8221 || i == 8250) {
                            type = 30;
                        }
                    }
                    ranges[type].addRange(i, i);
                    switch (type) {
                        case 1: 
                        case 2: 
                        case 3: 
                        case 4: 
                        case 5: {
                            type = 31;
                            break;
                        }
                        case 6: 
                        case 7: 
                        case 8: {
                            type = 32;
                            break;
                        }
                        case 9: 
                        case 10: 
                        case 11: {
                            type = 33;
                            break;
                        }
                        case 12: 
                        case 13: 
                        case 14: {
                            type = 34;
                            break;
                        }
                        case 0: 
                        case 15: 
                        case 16: 
                        case 18: 
                        case 19: {
                            type = 35;
                            break;
                        }
                        case 20: 
                        case 21: 
                        case 22: 
                        case 23: 
                        case 24: 
                        case 29: 
                        case 30: {
                            type = 36;
                            break;
                        }
                        case 25: 
                        case 26: 
                        case 27: 
                        case 28: {
                            type = 37;
                            break;
                        }
                        default: {
                            throw new RuntimeException(RX_Token.class.getName() + "#getRange(): Unknown Unicode category: " + type);
                        }
                    }
                    ranges[type].addRange(i, i);
                }
                ranges[0].addRange(65536, 0x10FFFF);
                for (i = 0; i < ranges.length; ++i) {
                    if (categoryNames[i] == null) continue;
                    if (i == 0) {
                        ranges[i].addRange(65536, 0x10FFFF);
                    }
                    categories.put(categoryNames[i], ranges[i]);
                    categories2.put(categoryNames[i], RX_Token.complementRanges(ranges[i]));
                }
                StringBuilder buffer = new StringBuilder(50);
                for (int i3 = 0; i3 < blockNames.length; ++i3) {
                    RangeToken r1 = RX_Token.createRange();
                    if (i3 < 84) {
                        location = i3 * 2;
                        char rstart = blockRanges.charAt(location);
                        char rend = blockRanges.charAt(location + 1);
                        ((RX_Token)r1).addRange(rstart, rend);
                    } else {
                        location = (i3 - 84) * 2;
                        ((RX_Token)r1).addRange(nonBMPBlockRanges[location], nonBMPBlockRanges[location + 1]);
                    }
                    String n = blockNames[i3];
                    if (n.equals("Specials")) {
                        ((RX_Token)r1).addRange(65520, 65533);
                    }
                    if (n.equals("Private Use")) {
                        ((RX_Token)r1).addRange(983040, 1048573);
                        ((RX_Token)r1).addRange(0x100000, 1114109);
                    }
                    categories.put(n, r1);
                    categories2.put(n, RX_Token.complementRanges(r1));
                    buffer.setLength(0);
                    buffer.append("Is");
                    if (n.indexOf(32) >= 0) {
                        for (int ci = 0; ci < n.length(); ++ci) {
                            if (n.charAt(ci) == ' ') continue;
                            buffer.append(n.charAt(ci));
                        }
                    } else {
                        buffer.append(n);
                    }
                    RX_Token.setAlias(buffer.toString(), n, true);
                }
                RX_Token.setAlias("ASSIGNED", "Cn", false);
                RX_Token.setAlias("UNASSIGNED", "Cn", true);
                RangeToken all = RX_Token.createRange();
                ((RX_Token)all).addRange(0, 0x10FFFF);
                categories.put("ALL", all);
                categories2.put("ALL", RX_Token.complementRanges(all));
                RX_Token.registerNonXS("ASSIGNED");
                RX_Token.registerNonXS("UNASSIGNED");
                RX_Token.registerNonXS("ALL");
                RangeToken isalpha = RX_Token.createRange();
                ((RX_Token)isalpha).mergeRanges(ranges[1]);
                ((RX_Token)isalpha).mergeRanges(ranges[2]);
                ((RX_Token)isalpha).mergeRanges(ranges[5]);
                categories.put("IsAlpha", isalpha);
                categories2.put("IsAlpha", RX_Token.complementRanges(isalpha));
                RX_Token.registerNonXS("IsAlpha");
                RangeToken isalnum = RX_Token.createRange();
                ((RX_Token)isalnum).mergeRanges(isalpha);
                ((RX_Token)isalnum).mergeRanges(ranges[9]);
                categories.put("IsAlnum", isalnum);
                categories2.put("IsAlnum", RX_Token.complementRanges(isalnum));
                RX_Token.registerNonXS("IsAlnum");
                RangeToken isspace = RX_Token.createRange();
                ((RX_Token)isspace).mergeRanges(token_spaces);
                ((RX_Token)isspace).mergeRanges(ranges[34]);
                categories.put("IsSpace", isspace);
                categories2.put("IsSpace", RX_Token.complementRanges(isspace));
                RX_Token.registerNonXS("IsSpace");
                RangeToken isword = RX_Token.createRange();
                ((RX_Token)isword).mergeRanges(isalnum);
                ((RX_Token)isword).addRange(95, 95);
                categories.put("IsWord", isword);
                categories2.put("IsWord", RX_Token.complementRanges(isword));
                RX_Token.registerNonXS("IsWord");
                RangeToken isascii = RX_Token.createRange();
                ((RX_Token)isascii).addRange(0, 127);
                categories.put("IsASCII", isascii);
                categories2.put("IsASCII", RX_Token.complementRanges(isascii));
                RX_Token.registerNonXS("IsASCII");
                RangeToken isnotgraph = RX_Token.createRange();
                ((RX_Token)isnotgraph).mergeRanges(ranges[35]);
                ((RX_Token)isnotgraph).addRange(32, 32);
                categories.put("IsGraph", RX_Token.complementRanges(isnotgraph));
                categories2.put("IsGraph", isnotgraph);
                RX_Token.registerNonXS("IsGraph");
                RangeToken isxdigit = RX_Token.createRange();
                ((RX_Token)isxdigit).addRange(48, 57);
                ((RX_Token)isxdigit).addRange(65, 70);
                ((RX_Token)isxdigit).addRange(97, 102);
                categories.put("IsXDigit", RX_Token.complementRanges(isxdigit));
                categories2.put("IsXDigit", isxdigit);
                RX_Token.registerNonXS("IsXDigit");
                RX_Token.setAlias("IsDigit", "Nd", true);
                RX_Token.setAlias("IsUpper", "Lu", true);
                RX_Token.setAlias("IsLower", "Ll", true);
                RX_Token.setAlias("IsCntrl", "C", true);
                RX_Token.setAlias("IsPrint", "C", false);
                RX_Token.setAlias("IsPunct", "P", true);
                RX_Token.registerNonXS("IsDigit");
                RX_Token.registerNonXS("IsUpper");
                RX_Token.registerNonXS("IsLower");
                RX_Token.registerNonXS("IsCntrl");
                RX_Token.registerNonXS("IsPrint");
                RX_Token.registerNonXS("IsPunct");
                RX_Token.setAlias("alpha", "IsAlpha", true);
                RX_Token.setAlias("alnum", "IsAlnum", true);
                RX_Token.setAlias("ascii", "IsASCII", true);
                RX_Token.setAlias("cntrl", "IsCntrl", true);
                RX_Token.setAlias("digit", "IsDigit", true);
                RX_Token.setAlias("graph", "IsGraph", true);
                RX_Token.setAlias("lower", "IsLower", true);
                RX_Token.setAlias("print", "IsPrint", true);
                RX_Token.setAlias("punct", "IsPunct", true);
                RX_Token.setAlias("space", "IsSpace", true);
                RX_Token.setAlias("upper", "IsUpper", true);
                RX_Token.setAlias("word", "IsWord", true);
                RX_Token.setAlias("xdigit", "IsXDigit", true);
                RX_Token.registerNonXS("alpha");
                RX_Token.registerNonXS("alnum");
                RX_Token.registerNonXS("ascii");
                RX_Token.registerNonXS("cntrl");
                RX_Token.registerNonXS("digit");
                RX_Token.registerNonXS("graph");
                RX_Token.registerNonXS("lower");
                RX_Token.registerNonXS("print");
                RX_Token.registerNonXS("punct");
                RX_Token.registerNonXS("space");
                RX_Token.registerNonXS("upper");
                RX_Token.registerNonXS("word");
                RX_Token.registerNonXS("xdigit");
            }
        }
        RangeToken tok = positive ? (RangeToken)categories.get(name) : (RangeToken)categories2.get(name);
        return tok;
    }

    protected static RangeToken getRange(String name, boolean positive, boolean xs) {
        RangeToken range = RX_Token.getRange(name, positive);
        if (xs && range != null && RX_Token.isRegisterNonXS(name)) {
            range = null;
        }
        return range;
    }

    protected static void registerNonXS(String name) {
        if (nonxs == null) {
            nonxs = new Hashtable();
        }
        nonxs.put(name, name);
    }

    protected static boolean isRegisterNonXS(String name) {
        if (nonxs == null) {
            return false;
        }
        return nonxs.containsKey(name);
    }

    private static void setAlias(String newName, String name, boolean positive) {
        RX_Token t1 = (RX_Token)categories.get(name);
        RX_Token t2 = (RX_Token)categories2.get(name);
        if (positive) {
            categories.put(newName, t1);
            categories2.put(newName, t2);
        } else {
            categories2.put(newName, t1);
            categories.put(newName, t2);
        }
    }

    static synchronized RX_Token getGraphemePattern() {
        if (token_grapheme != null) {
            return token_grapheme;
        }
        RangeToken base_char = RX_Token.createRange();
        ((RX_Token)base_char).mergeRanges(RX_Token.getRange("ASSIGNED", true));
        ((RX_Token)base_char).subtractRanges(RX_Token.getRange("M", true));
        ((RX_Token)base_char).subtractRanges(RX_Token.getRange("C", true));
        RangeToken virama = RX_Token.createRange();
        for (int i = 0; i < viramaString.length(); ++i) {
            ((RX_Token)virama).addRange(i, i);
        }
        RangeToken combiner_wo_virama = RX_Token.createRange();
        ((RX_Token)combiner_wo_virama).mergeRanges(RX_Token.getRange("M", true));
        ((RX_Token)combiner_wo_virama).addRange(4448, 4607);
        ((RX_Token)combiner_wo_virama).addRange(65438, 65439);
        UnionToken left = RX_Token.createUnion();
        ((RX_Token)left).addChild(base_char);
        ((RX_Token)left).addChild(token_empty);
        RX_Token foo = RX_Token.createUnion();
        ((RX_Token)foo).addChild(RX_Token.createConcat(virama, RX_Token.getRange("L", true)));
        ((RX_Token)foo).addChild(combiner_wo_virama);
        foo = RX_Token.createClosure(foo);
        foo = RX_Token.createConcat(left, foo);
        token_grapheme = foo;
        return token_grapheme;
    }

    static synchronized RX_Token getCombiningCharacterSequence() {
        if (token_ccs != null) {
            return token_ccs;
        }
        RX_Token foo = RX_Token.createClosure(RX_Token.getRange("M", true));
        foo = RX_Token.createConcat(RX_Token.getRange("M", false), foo);
        token_ccs = foo;
        return token_ccs;
    }

    static {
        token_empty = new RX_Token(7);
        token_linebeginning = RX_Token.createAnchor(94);
        token_linebeginning2 = RX_Token.createAnchor(64);
        token_lineend = RX_Token.createAnchor(36);
        token_stringbeginning = RX_Token.createAnchor(65);
        token_stringend = RX_Token.createAnchor(122);
        token_stringend2 = RX_Token.createAnchor(90);
        token_wordedge = RX_Token.createAnchor(98);
        token_not_wordedge = RX_Token.createAnchor(66);
        token_wordbeginning = RX_Token.createAnchor(60);
        token_wordend = RX_Token.createAnchor(62);
        token_dot = new RX_Token(11);
        token_0to9 = RX_Token.createRange();
        token_0to9.addRange(48, 57);
        token_wordchars = RX_Token.createRange();
        token_wordchars.addRange(48, 57);
        token_wordchars.addRange(65, 90);
        token_wordchars.addRange(95, 95);
        token_wordchars.addRange(97, 122);
        token_spaces = RX_Token.createRange();
        token_spaces.addRange(9, 9);
        token_spaces.addRange(10, 10);
        token_spaces.addRange(12, 12);
        token_spaces.addRange(13, 13);
        token_spaces.addRange(32, 32);
        token_not_0to9 = RX_Token.complementRanges(token_0to9);
        token_not_wordchars = RX_Token.complementRanges(token_wordchars);
        token_not_spaces = RX_Token.complementRanges(token_spaces);
        categories = new Hashtable();
        categories2 = new Hashtable();
        categoryNames = new String[]{"Cn", "Lu", "Ll", "Lt", "Lm", "Lo", "Mn", "Me", "Mc", "Nd", "Nl", "No", "Zs", "Zl", "Zp", "Cc", "Cf", null, "Co", "Cs", "Pd", "Ps", "Pe", "Pc", "Po", "Sm", "Sc", "Sk", "So", "Pi", "Pf", "L", "M", "N", "Z", "C", "P", "S"};
        blockNames = new String[]{"Basic Latin", "Latin-1 Supplement", "Latin Extended-A", "Latin Extended-B", "IPA Extensions", "Spacing Modifier Letters", "Combining Diacritical Marks", "Greek", "Cyrillic", "Armenian", "Hebrew", "Arabic", "Syriac", "Thaana", "Devanagari", "Bengali", "Gurmukhi", "Gujarati", "Oriya", "Tamil", "Telugu", "Kannada", "Malayalam", "Sinhala", "Thai", "Lao", "Tibetan", "Myanmar", "Georgian", "Hangul Jamo", "Ethiopic", "Cherokee", "Unified Canadian Aboriginal Syllabics", "Ogham", "Runic", "Khmer", "Mongolian", "Latin Extended Additional", "Greek Extended", "General Punctuation", "Superscripts and Subscripts", "Currency Symbols", "Combining Marks for Symbols", "Letterlike Symbols", "Number Forms", "Arrows", "Mathematical Operators", "Miscellaneous Technical", "Control Pictures", "Optical Character Recognition", "Enclosed Alphanumerics", "Box Drawing", "Block Elements", "Geometric Shapes", "Miscellaneous Symbols", "Dingbats", "Braille Patterns", "CJK Radicals Supplement", "Kangxi Radicals", "Ideographic Description Characters", "CJK Symbols and Punctuation", "Hiragana", "Katakana", "Bopomofo", "Hangul Compatibility Jamo", "Kanbun", "Bopomofo Extended", "Enclosed CJK Letters and Months", "CJK Compatibility", "CJK Unified Ideographs Extension A", "CJK Unified Ideographs", "Yi Syllables", "Yi Radicals", "Hangul Syllables", "Private Use", "CJK Compatibility Ideographs", "Alphabetic Presentation Forms", "Arabic Presentation Forms-A", "Combining Half Marks", "CJK Compatibility Forms", "Small Form Variants", "Arabic Presentation Forms-B", "Specials", "Halfwidth and Fullwidth Forms", "Old Italic", "Gothic", "Deseret", "Byzantine Musical Symbols", "Musical Symbols", "Mathematical Alphanumeric Symbols", "CJK Unified Ideographs Extension B", "CJK Compatibility Ideographs Supplement", "Tags"};
        nonBMPBlockRanges = new int[]{66304, 66351, 66352, 66383, 66560, 66639, 118784, 119039, 119040, 119295, 119808, 120831, 131072, 173782, 194560, 195103, 917504, 917631};
        nonxs = null;
        token_grapheme = null;
        token_ccs = null;
    }

    static class ParenToken
    extends RX_Token
    implements Serializable {
        private static final long serialVersionUID = -5938014719827987704L;
        final RX_Token child;
        final int parennumber;

        ParenToken(int type, RX_Token tok, int paren) {
            super(type);
            this.child = tok;
            this.parennumber = paren;
        }

        @Override
        int size() {
            return 1;
        }

        @Override
        RX_Token getChild(int index) {
            return this.child;
        }

        @Override
        int getParenNumber() {
            return this.parennumber;
        }

        @Override
        public String toString(int options) {
            String ret = null;
            switch (this.type) {
                case 6: {
                    if (this.parennumber == 0) {
                        ret = "(?:" + this.child.toString(options) + ")";
                        break;
                    }
                    ret = "(" + this.child.toString(options) + ")";
                    break;
                }
                case 20: {
                    ret = "(?=" + this.child.toString(options) + ")";
                    break;
                }
                case 21: {
                    ret = "(?!" + this.child.toString(options) + ")";
                    break;
                }
                case 22: {
                    ret = "(?<=" + this.child.toString(options) + ")";
                    break;
                }
                case 23: {
                    ret = "(?<!" + this.child.toString(options) + ")";
                    break;
                }
                case 24: {
                    ret = "(?>" + this.child.toString(options) + ")";
                }
            }
            return ret;
        }
    }

    static class ClosureToken
    extends RX_Token
    implements Serializable {
        private static final long serialVersionUID = 1308971930673997452L;
        int min;
        int max;
        final RX_Token child;

        ClosureToken(int type, RX_Token tok) {
            super(type);
            this.child = tok;
            this.setMin(-1);
            this.setMax(-1);
        }

        @Override
        int size() {
            return 1;
        }

        @Override
        RX_Token getChild(int index) {
            return this.child;
        }

        @Override
        final void setMin(int min2) {
            this.min = min2;
        }

        @Override
        final void setMax(int max2) {
            this.max = max2;
        }

        @Override
        final int getMin() {
            return this.min;
        }

        @Override
        final int getMax() {
            return this.max;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public String toString(int options) {
            if (this.type == 3) {
                if (this.getMin() < 0 && this.getMax() < 0) {
                    return this.child.toString(options) + "*";
                }
                if (this.getMin() == this.getMax()) {
                    return this.child.toString(options) + "{" + this.getMin() + "}";
                }
                if (this.getMin() >= 0 && this.getMax() >= 0) {
                    return this.child.toString(options) + "{" + this.getMin() + "," + this.getMax() + "}";
                }
                if (this.getMin() < 0) throw new RuntimeException("Token#toString(): CLOSURE " + this.getMin() + ", " + this.getMax());
                if (this.getMax() >= 0) throw new RuntimeException("Token#toString(): CLOSURE " + this.getMin() + ", " + this.getMax());
                return this.child.toString(options) + "{" + this.getMin() + ",}";
            }
            if (this.getMin() < 0 && this.getMax() < 0) {
                return this.child.toString(options) + "*?";
            }
            if (this.getMin() == this.getMax()) {
                return this.child.toString(options) + "{" + this.getMin() + "}?";
            }
            if (this.getMin() >= 0 && this.getMax() >= 0) {
                return this.child.toString(options) + "{" + this.getMin() + "," + this.getMax() + "}?";
            }
            if (this.getMin() < 0) throw new RuntimeException("Token#toString(): NONGREEDYCLOSURE " + this.getMin() + ", " + this.getMax());
            if (this.getMax() >= 0) throw new RuntimeException("Token#toString(): NONGREEDYCLOSURE " + this.getMin() + ", " + this.getMax());
            return this.child.toString(options) + "{" + this.getMin() + ",}?";
        }
    }

    static class ConcatToken
    extends RX_Token
    implements Serializable {
        private static final long serialVersionUID = 8717321425541346381L;
        final RX_Token child;
        final RX_Token child2;

        ConcatToken(RX_Token t1, RX_Token t2) {
            super(1);
            this.child = t1;
            this.child2 = t2;
        }

        @Override
        int size() {
            return 2;
        }

        @Override
        RX_Token getChild(int index) {
            return index == 0 ? this.child : this.child2;
        }

        @Override
        public String toString(int options) {
            String ret = this.child2.type == 3 && this.child2.getChild(0) == this.child ? this.child.toString(options) + "+" : (this.child2.type == 9 && this.child2.getChild(0) == this.child ? this.child.toString(options) + "+?" : this.child.toString(options) + this.child2.toString(options));
            return ret;
        }
    }

    static class UnionToken
    extends RX_Token
    implements Serializable {
        private static final long serialVersionUID = -2568843945989489861L;
        Vector children;

        UnionToken(int type) {
            super(type);
        }

        @Override
        void addChild(RX_Token tok) {
            int ch;
            StringBuilder buffer;
            int nextMaxLength;
            if (tok == null) {
                return;
            }
            if (this.children == null) {
                this.children = new Vector();
            }
            if (this.type == 2) {
                this.children.addElement(tok);
                return;
            }
            if (tok.type == 1) {
                for (int i = 0; i < tok.size(); ++i) {
                    this.addChild(tok.getChild(i));
                }
                return;
            }
            int size = this.children.size();
            if (size == 0) {
                this.children.addElement(tok);
                return;
            }
            RX_Token previous = (RX_Token)this.children.elementAt(size - 1);
            if (previous.type != 0 && previous.type != 10 || tok.type != 0 && tok.type != 10) {
                this.children.addElement(tok);
                return;
            }
            int n = nextMaxLength = tok.type == 0 ? 2 : tok.getString().length();
            if (previous.type == 0) {
                buffer = new StringBuilder(2 + nextMaxLength);
                ch = previous.getChar();
                if (ch >= 65536) {
                    buffer.append(REUtil.decomposeToSurrogates(ch));
                } else {
                    buffer.append((char)ch);
                }
                previous = RX_Token.createString(null);
                this.children.setElementAt(previous, size - 1);
            } else {
                buffer = new StringBuilder(previous.getString().length() + nextMaxLength);
                buffer.append(previous.getString());
            }
            if (tok.type == 0) {
                ch = tok.getChar();
                if (ch >= 65536) {
                    buffer.append(REUtil.decomposeToSurrogates(ch));
                } else {
                    buffer.append((char)ch);
                }
            } else {
                buffer.append(tok.getString());
            }
            ((StringToken)previous).string = new String(buffer);
        }

        @Override
        int size() {
            return this.children == null ? 0 : this.children.size();
        }

        @Override
        RX_Token getChild(int index) {
            return (RX_Token)this.children.elementAt(index);
        }

        @Override
        public String toString(int options) {
            Object ret;
            if (this.type == 1) {
                Object ret2;
                if (this.children.size() == 2) {
                    RX_Token ch = this.getChild(0);
                    RX_Token ch2 = this.getChild(1);
                    ret2 = ch2.type == 3 && ch2.getChild(0) == ch ? ch.toString(options) + "+" : (ch2.type == 9 && ch2.getChild(0) == ch ? ch.toString(options) + "+?" : ch.toString(options) + ch2.toString(options));
                } else {
                    StringBuilder sb = new StringBuilder();
                    for (int i = 0; i < this.children.size(); ++i) {
                        sb.append(((RX_Token)this.children.elementAt(i)).toString(options));
                    }
                    ret2 = new String(sb);
                }
                return ret2;
            }
            if (this.children.size() == 2 && this.getChild((int)1).type == 7) {
                ret = this.getChild(0).toString(options) + "?";
            } else if (this.children.size() == 2 && this.getChild((int)0).type == 7) {
                ret = this.getChild(1).toString(options) + "??";
            } else {
                StringBuilder sb = new StringBuilder();
                sb.append(((RX_Token)this.children.elementAt(0)).toString(options));
                for (int i = 1; i < this.children.size(); ++i) {
                    sb.append('|');
                    sb.append(((RX_Token)this.children.elementAt(i)).toString(options));
                }
                ret = new String(sb);
            }
            return ret;
        }
    }

    static class CharToken
    extends RX_Token
    implements Serializable {
        private static final long serialVersionUID = -4394272816279496989L;
        final int chardata;

        CharToken(int type, int ch) {
            super(type);
            this.chardata = ch;
        }

        @Override
        int getChar() {
            return this.chardata;
        }

        @Override
        public String toString(int options) {
            return switch (this.type) {
                case 0 -> {
                    switch (this.chardata) {
                        case 40: 
                        case 41: 
                        case 42: 
                        case 43: 
                        case 46: 
                        case 63: 
                        case 91: 
                        case 92: 
                        case 123: 
                        case 124: {
                            yield "\\" + (char)this.chardata;
                        }
                        case 12: {
                            yield "\\f";
                        }
                        case 10: {
                            yield "\\n";
                        }
                        case 13: {
                            yield "\\r";
                        }
                        case 9: {
                            yield "\\t";
                        }
                        case 27: {
                            yield "\\e";
                        }
                    }
                    if (this.chardata >= 65536) {
                        String pre = "0" + Integer.toHexString(this.chardata);
                        yield "\\v" + pre.substring(pre.length() - 6, pre.length());
                    }
                    yield "" + (char)this.chardata;
                }
                case 8 -> {
                    if (this == token_linebeginning || this == token_lineend) {
                        yield "" + (char)this.chardata;
                    }
                    yield "\\" + (char)this.chardata;
                }
                default -> null;
            };
        }

        @Override
        boolean match(int ch) {
            if (this.type == 0) {
                return ch == this.chardata;
            }
            throw new RuntimeException("NFAArrow#match(): Internal error: " + this.type);
        }
    }

    static class StringToken
    extends RX_Token
    implements Serializable {
        private static final long serialVersionUID = -4614366944218504172L;
        String string;
        final int refNumber;

        StringToken(int type, String str2, int n) {
            super(type);
            this.string = str2;
            this.refNumber = n;
        }

        @Override
        int getReferenceNumber() {
            return this.refNumber;
        }

        @Override
        String getString() {
            return this.string;
        }

        @Override
        public String toString(int options) {
            if (this.type == 12) {
                return "\\" + this.refNumber;
            }
            return REUtil.quoteMeta(this.string);
        }
    }

    static class ModifierToken
    extends RX_Token
    implements Serializable {
        private static final long serialVersionUID = -9114536559696480356L;
        final RX_Token child;
        final int add;
        final int mask;

        ModifierToken(RX_Token tok, int add, int mask) {
            super(25);
            this.child = tok;
            this.add = add;
            this.mask = mask;
        }

        @Override
        int size() {
            return 1;
        }

        @Override
        RX_Token getChild(int index) {
            return this.child;
        }

        int getOptions() {
            return this.add;
        }

        int getOptionsMask() {
            return this.mask;
        }

        @Override
        public String toString(int options) {
            return "(?" + (this.add == 0 ? "" : REUtil.createOptionString(this.add)) + (this.mask == 0 ? "" : REUtil.createOptionString(this.mask)) + ":" + this.child.toString(options) + ")";
        }
    }

    static class ConditionToken
    extends RX_Token
    implements Serializable {
        private static final long serialVersionUID = 4353765277910594411L;
        final int refNumber;
        final RX_Token condition;
        final RX_Token yes;
        final RX_Token no;

        ConditionToken(int refno, RX_Token cond, RX_Token yespat, RX_Token nopat) {
            super(26);
            this.refNumber = refno;
            this.condition = cond;
            this.yes = yespat;
            this.no = nopat;
        }

        @Override
        int size() {
            return this.no == null ? 1 : 2;
        }

        @Override
        RX_Token getChild(int index) {
            if (index == 0) {
                return this.yes;
            }
            if (index == 1) {
                return this.no;
            }
            throw new RuntimeException("Internal Error: " + index);
        }

        @Override
        public String toString(int options) {
            String ret = this.refNumber > 0 ? "(?(" + this.refNumber + ")" : (this.condition.type == 8 ? "(?(" + this.condition + ")" : "(?" + this.condition);
            ret = this.no == null ? ret + this.yes + ")" : ret + this.yes + "|" + this.no + ")";
            return ret;
        }
    }

    static class FixedStringContainer {
        RX_Token token = null;
        int options = 0;

        FixedStringContainer() {
        }
    }
}

