/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.core;

import org.apache.jena.atlas.logging.Log;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.Node;
import org.apache.jena.query.ReadWrite;
import org.apache.jena.sparql.core.DatasetGraph;
import org.apache.jena.sparql.core.DatasetGraphWrapper;
import org.apache.jena.sparql.graph.GraphReadOnly;
import org.apache.jena.sparql.util.Context;

public class DatasetGraphReadOnly
extends DatasetGraphWrapper {
    private Graph dftGraph = new GraphReadOnly(super.getDefaultGraph());

    public DatasetGraphReadOnly(DatasetGraph dsg) {
        super(dsg);
    }

    public DatasetGraphReadOnly(DatasetGraph dsg, Context cxt) {
        super(dsg, cxt);
    }

    @Override
    public Graph getDefaultGraph() {
        return this.dftGraph;
    }

    @Override
    public void begin(ReadWrite mode) {
        if (mode == ReadWrite.WRITE) {
            Log.warn((Object)this, (String)"Write transaction on a read-only dataset");
        }
        this.get().begin(mode);
    }

    @Override
    public Graph getGraph(Node graphNode) {
        Object g = this.get().getGraph(graphNode);
        if (g == null) {
            return null;
        }
        g = new GraphReadOnly((Graph)g);
        return g;
    }

    @Override
    protected DatasetGraph getW() {
        throw new UnsupportedOperationException("read-only dataset");
    }

    @Override
    public void close() {
        this.get().close();
    }
}

