/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.atlas.lib;

import java.io.PrintStream;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.jena.atlas.iterator.Iter;

public class StreamOps {
    public static <X> Stream<X> stream(Iterator<X> iter) {
        return Iter.asStream(iter);
    }

    public static <X> Set<X> toSet(Stream<X> stream) {
        return stream.collect(Collectors.toSet());
    }

    public static <X> X first(Stream<X> stream) {
        return stream.findFirst().orElse(null);
    }

    public static <X> X element(Collection<X> collection) {
        return StreamOps.first(collection.stream());
    }

    public static <X> Stream<X> print(Stream<X> stream) {
        return StreamOps.print(System.out, stream);
    }

    public static <X> Stream<X> print(PrintStream out, Stream<X> stream) {
        stream = stream.map(item -> {
            out.println(item);
            return item;
        });
        return stream.toList().stream();
    }

    public static <X> Stream<X> print(PrintStream out, String leader, Stream<X> stream) {
        String prefix = leader == null ? "" : leader;
        stream = stream.map(item -> {
            out.print(prefix);
            out.println(item);
            return item;
        });
        return stream.toList().stream();
    }

    public static <X> Stream<X> debug(Stream<X> stream) {
        List<X> elts = stream.toList();
        if (elts.isEmpty()) {
            System.out.println("[empty]");
        } else {
            StringJoiner sj = new StringJoiner("\n  ", "[\n  ", "\n]");
            elts.forEach(b -> sj.add(b.toString()));
            System.out.println(sj.toString());
        }
        return elts.stream();
    }
}

