/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.dboe.trans.bplustree;

import java.util.Arrays;
import java.util.Collection;
import org.apache.jena.dboe.trans.bplustree.BPT;
import org.apache.jena.dboe.trans.bplustree.TestBPlusTreeNonTxn;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class TestBPTreeModes
extends TestBPlusTreeNonTxn {
    boolean modeAtStartNodes;
    boolean modeAtStartRecords;

    @Parameterized.Parameters(name="Node dup={0}, Record dup={1}")
    public static Collection<Object[]> data() {
        return Arrays.asList({true, true}, {true, false}, {false, true}, {false, false});
    }

    public TestBPTreeModes(boolean nodeMode, boolean recordsMode) {
        BPT.promoteDuplicateNodes = nodeMode;
        BPT.promoteDuplicateRecords = recordsMode;
    }

    @BeforeClass
    public static void setupSuite() {
        BPT.forcePromoteModes = true;
    }

    @AfterClass
    public static void resetSuite() {
        BPT.forcePromoteModes = false;
    }

    @Before
    public void setModes() {
        BPT.forcePromoteModes = true;
        this.modeAtStartNodes = BPT.promoteDuplicateNodes;
        this.modeAtStartRecords = BPT.promoteDuplicateRecords;
    }

    @After
    public void resetModes() {
        BPT.promoteDuplicateNodes = this.modeAtStartNodes;
        BPT.promoteDuplicateRecords = this.modeAtStartRecords;
    }
}

