/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.dboe.trans.bplustree;

import org.apache.jena.dboe.base.block.BlockMgr;
import org.apache.jena.dboe.base.block.BlockMgrFactory;
import org.apache.jena.dboe.base.buffer.RecordBuffer;
import org.apache.jena.dboe.base.record.Record;
import org.apache.jena.dboe.base.record.RecordFactory;
import org.apache.jena.dboe.base.recordbuffer.RecordBufferPage;
import org.apache.jena.dboe.base.recordbuffer.RecordBufferPageMgr;
import org.apache.jena.dboe.sys.SystemIndex;
import org.apache.jena.dboe.test.RecordLib;
import org.apache.jena.dboe.trans.bplustree.BPT;
import org.apache.jena.dboe.trans.bplustree.BPTreePage;
import org.apache.jena.dboe.trans.bplustree.BPTreeRecords;
import org.apache.jena.dboe.trans.bplustree.BPTreeRecordsMgr;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class TestBPTreeRecordsNonTxn
extends Assert {
    private static boolean oldNullOut;
    private static int blockSize;
    private static RecordFactory recordFactory;
    private static int bufSizeRecord;
    private static BlockMgr blkMgrRecords;
    private static RecordBufferPageMgr recordBufferPageMgr;

    @BeforeClass
    public static void beforeClass() {
        oldNullOut = SystemIndex.getNullOut();
        SystemIndex.setNullOut((boolean)true);
        blockSize = 32;
        recordFactory = new RecordFactory(4, 0);
        bufSizeRecord = RecordBufferPage.calcRecordSize((RecordFactory)recordFactory, (int)blockSize);
        blkMgrRecords = BlockMgrFactory.createMem((String)"BPTreeRecords", (int)blockSize);
        recordBufferPageMgr = new RecordBufferPageMgr(recordFactory, blkMgrRecords);
        BlockMgr blkMgrNodes = BlockMgrFactory.createMem((String)"BPTreeNs", (int)blockSize);
        BPT.forcePromoteModes = true;
        BPT.promoteDuplicateRecords = true;
    }

    @AfterClass
    public static void afterClass() {
        SystemIndex.setNullOut((boolean)oldNullOut);
        BPT.forcePromoteModes = false;
    }

    @Before
    public void before() {
        blkMgrRecords.beginUpdate();
    }

    @After
    public void after() {
        blkMgrRecords.endUpdate();
    }

    @Test
    public void bpt_records_1() {
        BPTreeRecords bpr = TestBPTreeRecordsNonTxn.make();
        TestBPTreeRecordsNonTxn.fill(bpr);
        TestBPTreeRecordsNonTxn.check(bpr);
        bpr.release();
    }

    @Test
    public void bpt_records_2() {
        BPTreeRecords bpr = TestBPTreeRecordsNonTxn.make();
        TestBPTreeRecordsNonTxn.fill(bpr);
        int s = bpr.getCount();
        TestBPTreeRecordsNonTxn.assertTrue((boolean)bpr.isFull());
        BPTreePage z = bpr.split();
        TestBPTreeRecordsNonTxn.assertTrue((boolean)(z instanceof BPTreeRecords));
        TestBPTreeRecordsNonTxn.assertEquals((long)s, (long)(z.getCount() + bpr.getCount()));
        TestBPTreeRecordsNonTxn.check(bpr);
        TestBPTreeRecordsNonTxn.check((BPTreeRecords)z);
        bpr.release();
        z.release();
    }

    @Test
    public void bpt_records_3() {
        BPTreeRecords bpr = TestBPTreeRecordsNonTxn.make();
        int i = 0;
        while (bpr.getCount() < bpr.getMaxSize()) {
            TestBPTreeRecordsNonTxn.insert(bpr, i + 32);
            ++i;
        }
        TestBPTreeRecordsNonTxn.check(bpr);
        bpr.release();
    }

    @Test
    public void bpt_records_4() {
        BPTreeRecords bpr = TestBPTreeRecordsNonTxn.make();
        for (int i = bpr.getMaxSize() - 1; i >= 0; --i) {
            TestBPTreeRecordsNonTxn.insert(bpr, i + 32);
        }
        TestBPTreeRecordsNonTxn.check(bpr);
        bpr.release();
    }

    @Test
    public void bpt_records_5() {
        BPTreeRecords bpr = TestBPTreeRecordsNonTxn.make();
        int N = bpr.getMaxSize();
        for (int i = bpr.getMaxSize() - 1; i >= 0; --i) {
            TestBPTreeRecordsNonTxn.insert(bpr, i + 32);
        }
        TestBPTreeRecordsNonTxn.delete(bpr, 33);
        TestBPTreeRecordsNonTxn.assertEquals((long)(N - 1), (long)bpr.getCount());
        TestBPTreeRecordsNonTxn.check(bpr);
        TestBPTreeRecordsNonTxn.delete(bpr, 34);
        TestBPTreeRecordsNonTxn.assertEquals((long)(N - 2), (long)bpr.getCount());
        TestBPTreeRecordsNonTxn.check(bpr);
        TestBPTreeRecordsNonTxn.delete(bpr, bpr.getLowRecord());
        TestBPTreeRecordsNonTxn.assertEquals((long)(N - 3), (long)bpr.getCount());
        TestBPTreeRecordsNonTxn.check(bpr);
        TestBPTreeRecordsNonTxn.delete(bpr, bpr.getHighRecord());
        TestBPTreeRecordsNonTxn.assertEquals((long)(N - 4), (long)bpr.getCount());
        TestBPTreeRecordsNonTxn.check(bpr);
        bpr.release();
    }

    @Test
    public void bpt_records_6() {
        BPTreeRecords bpr = TestBPTreeRecordsNonTxn.make();
        TestBPTreeRecordsNonTxn.fill(bpr);
        TestBPTreeRecordsNonTxn.assertNull((Object)TestBPTreeRecordsNonTxn.search(bpr, RecordLib.intToRecord((int)32)));
        Record r = RecordLib.intToRecord((int)50);
        Record r2 = TestBPTreeRecordsNonTxn.search(bpr, r);
        TestBPTreeRecordsNonTxn.assertTrue((boolean)Record.keyEQ((Record)r, (Record)r2));
        r = bpr.getLowRecord();
        r2 = TestBPTreeRecordsNonTxn.search(bpr, r);
        TestBPTreeRecordsNonTxn.assertTrue((boolean)Record.keyEQ((Record)r, (Record)r2));
        r = bpr.getHighRecord();
        r2 = TestBPTreeRecordsNonTxn.search(bpr, r);
        TestBPTreeRecordsNonTxn.assertTrue((boolean)Record.keyEQ((Record)r, (Record)r2));
        bpr.release();
    }

    @Test
    public void bpt_shift_1() {
        BPTreeRecords bpr1 = TestBPTreeRecordsNonTxn.make();
        BPTreeRecords bpr2 = TestBPTreeRecordsNonTxn.make();
        TestBPTreeRecordsNonTxn.insert(bpr1, 10);
        Record r = bpr1.shiftRight((BPTreePage)bpr2, null);
        TestBPTreeRecordsNonTxn.assertNull((Object)r);
        TestBPTreeRecordsNonTxn.contains(bpr1, new int[0]);
        TestBPTreeRecordsNonTxn.contains(bpr2, 10);
        bpr1.release();
        bpr2.release();
    }

    @Test
    public void bpt_shift_2() {
        BPTreeRecords bpr1 = TestBPTreeRecordsNonTxn.make();
        BPTreeRecords bpr2 = TestBPTreeRecordsNonTxn.make();
        TestBPTreeRecordsNonTxn.insert(bpr1, 10);
        Record r = bpr2.shiftLeft((BPTreePage)bpr1, null);
        TestBPTreeRecordsNonTxn.assertTrue((boolean)Record.keyEQ((Record)r, (Record)RecordLib.intToRecord((int)10)));
        TestBPTreeRecordsNonTxn.contains(bpr1, new int[0]);
        TestBPTreeRecordsNonTxn.contains(bpr2, 10);
        bpr1.release();
        bpr2.release();
    }

    @Test
    public void bpt_shift_3() {
        BPTreeRecords bpr1 = TestBPTreeRecordsNonTxn.make();
        BPTreeRecords bpr2 = TestBPTreeRecordsNonTxn.make();
        TestBPTreeRecordsNonTxn.insert(bpr1, 10, 20);
        TestBPTreeRecordsNonTxn.insert(bpr2, 99);
        Record r = bpr1.shiftRight((BPTreePage)bpr2, null);
        TestBPTreeRecordsNonTxn.assertTrue((String)(r + " != " + RecordLib.intToRecord((int)10)), (boolean)Record.keyEQ((Record)r, (Record)RecordLib.intToRecord((int)10)));
        TestBPTreeRecordsNonTxn.contains(bpr1, 10);
        TestBPTreeRecordsNonTxn.contains(bpr2, 20, 99);
        bpr1.release();
        bpr2.release();
    }

    @Test
    public void bpt_shift_4() {
        BPTreeRecords bpr1 = TestBPTreeRecordsNonTxn.make();
        BPTreeRecords bpr2 = TestBPTreeRecordsNonTxn.make();
        TestBPTreeRecordsNonTxn.insert(bpr1, 10, 20);
        TestBPTreeRecordsNonTxn.insert(bpr2, 5);
        Record r = bpr2.shiftLeft((BPTreePage)bpr1, null);
        TestBPTreeRecordsNonTxn.assertTrue((boolean)Record.keyEQ((Record)r, (Record)RecordLib.intToRecord((int)10)));
        TestBPTreeRecordsNonTxn.contains(bpr1, 20);
        TestBPTreeRecordsNonTxn.contains(bpr2, 5, 10);
        bpr1.release();
        bpr2.release();
    }

    @Test
    public void bpt_merge_1() {
        BPTreeRecords bpr1 = TestBPTreeRecordsNonTxn.make();
        BPTreeRecords bpr2 = TestBPTreeRecordsNonTxn.make();
        TestBPTreeRecordsNonTxn.insert(bpr1, 10, 20);
        TestBPTreeRecordsNonTxn.insert(bpr2, 99);
        BPTreeRecords bpr3 = (BPTreeRecords)bpr1.merge((BPTreePage)bpr2, null);
        TestBPTreeRecordsNonTxn.contains(bpr1, 10, 20, 99);
        TestBPTreeRecordsNonTxn.contains(bpr2, new int[0]);
        TestBPTreeRecordsNonTxn.assertSame((Object)bpr1, (Object)bpr3);
        bpr1.release();
        bpr2.release();
    }

    @Test
    public void bpt_merge_2() {
        BPTreeRecords bpr1 = TestBPTreeRecordsNonTxn.make();
        BPTreeRecords bpr2 = TestBPTreeRecordsNonTxn.make();
        TestBPTreeRecordsNonTxn.insert(bpr1, 10, 20);
        TestBPTreeRecordsNonTxn.insert(bpr2, 5);
        BPTreeRecords bpr3 = (BPTreeRecords)bpr2.merge((BPTreePage)bpr1, null);
        TestBPTreeRecordsNonTxn.contains(bpr1, new int[0]);
        TestBPTreeRecordsNonTxn.contains(bpr2, 5, 10, 20);
        TestBPTreeRecordsNonTxn.assertSame((Object)bpr2, (Object)bpr3);
        bpr1.release();
        bpr2.release();
    }

    protected static void check(BPTreeRecords bpr) {
        TestBPTreeRecordsNonTxn.assertTrue((bpr.getCount() >= 0 ? 1 : 0) != 0);
        TestBPTreeRecordsNonTxn.assertTrue((bpr.getCount() <= bpr.getMaxSize() ? 1 : 0) != 0);
        TestBPTreeRecordsNonTxn.assertEquals((Object)bpr.getRecordBuffer().getLow(), (Object)bpr.getLowRecord());
        TestBPTreeRecordsNonTxn.assertEquals((Object)bpr.getRecordBuffer().getHigh(), (Object)bpr.getHighRecord());
        for (int i = 1; i < bpr.getCount(); ++i) {
            Record r1 = bpr.getRecordBuffer().get(i - 1);
            Record r2 = bpr.getRecordBuffer().get(i);
            TestBPTreeRecordsNonTxn.assertTrue((boolean)Record.keyLE((Record)r1, (Record)r2));
        }
    }

    private static Record search(BPTreeRecords bpr, int x) {
        return TestBPTreeRecordsNonTxn.search(bpr, RecordLib.intToRecord((int)x));
    }

    private static Record search(BPTreeRecords bpr, Record r) {
        return bpr.internalSearch(null, r);
    }

    private static void insert(BPTreeRecords bpr, int ... values) {
        for (int value : values) {
            bpr.internalInsert(null, RecordLib.intToRecord((int)value));
        }
    }

    private static void insert(BPTreeRecords bpr, Record r) {
        bpr.internalInsert(null, r);
    }

    private static void delete(BPTreeRecords bpr, int ... values) {
        for (int value : values) {
            TestBPTreeRecordsNonTxn.delete(bpr, RecordLib.intToRecord((int)value));
        }
    }

    private static void delete(BPTreeRecords bpr, Record r) {
        bpr.internalDelete(null, r);
    }

    private static void contains(BPTreeRecords bpr, int ... values) {
        TestBPTreeRecordsNonTxn.assertEquals((long)values.length, (long)bpr.getCount());
        for (int i = 1; i < values.length; ++i) {
            TestBPTreeRecordsNonTxn.assertTrue((Record.compareByKeyValue((Record)RecordLib.intToRecord((int)values[i]), (Record)bpr.getRecordBuffer().get(i)) == 0 ? 1 : 0) != 0);
        }
    }

    protected static BPTreeRecords make() {
        RecordBufferPage page = recordBufferPageMgr.create();
        BPTreeRecordsMgr mgr = new BPTreeRecordsMgr(null, recordFactory, recordBufferPageMgr);
        return new BPTreeRecords(mgr, page);
    }

    protected static void fill(BPTreeRecords bpr) {
        int N = bpr.getRecordBuffer().maxSize();
        for (int i = 0; i < N; ++i) {
            RecordBuffer rb = bpr.getRecordBuffer();
            TestBPTreeRecordsNonTxn.insert(bpr, i + 48);
        }
    }
}

