/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.dboe.trans.bplustree.rewriter;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.jena.atlas.lib.Bytes;
import org.apache.jena.dboe.base.block.BlockMgr;
import org.apache.jena.dboe.base.block.BlockMgrFactory;
import org.apache.jena.dboe.base.file.BufferChannel;
import org.apache.jena.dboe.base.file.FileFactory;
import org.apache.jena.dboe.base.file.FileSet;
import org.apache.jena.dboe.base.record.Record;
import org.apache.jena.dboe.base.record.RecordFactory;
import org.apache.jena.dboe.trans.bplustree.BPTreeException;
import org.apache.jena.dboe.trans.bplustree.BPlusTree;
import org.apache.jena.dboe.trans.bplustree.BPlusTreeParams;
import org.apache.jena.dboe.trans.bplustree.rewriter.BPlusTreeRewriter;
import org.apache.jena.dboe.trans.bplustree.rewriter.BPlusTreeRewriterUtils;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class TestBPlusTreeRewriterNonTxn
extends Assert {
    static int KeySize = 4;
    static int ValueSize = 8;
    static RecordFactory recordFactory = new RecordFactory(KeySize, ValueSize);
    static boolean b;

    @BeforeClass
    public static void beforeClass() {
        b = BlockMgrFactory.AddTracker;
        BlockMgrFactory.AddTracker = false;
    }

    @AfterClass
    public static void afterClass() {
        BlockMgrFactory.AddTracker = b;
    }

    @Test
    public void bpt_rewrite_01() {
        TestBPlusTreeRewriterNonTxn.runTest(2, 0);
    }

    @Test
    public void bpt_rewrite_02() {
        TestBPlusTreeRewriterNonTxn.runTest(3, 0);
    }

    @Test
    public void bpt_rewrite_03() {
        TestBPlusTreeRewriterNonTxn.runTest(2, 1);
    }

    @Test
    public void bpt_rewrite_04() {
        TestBPlusTreeRewriterNonTxn.runTest(3, 1);
    }

    @Test
    public void bpt_rewrite_05() {
        TestBPlusTreeRewriterNonTxn.runTest(2, 2);
    }

    @Test
    public void bpt_rewrite_06() {
        TestBPlusTreeRewriterNonTxn.runTest(3, 2);
    }

    @Test
    public void bpt_rewrite_07() {
        TestBPlusTreeRewriterNonTxn.runTest(2, 100);
    }

    @Test
    public void bpt_rewrite_08() {
        TestBPlusTreeRewriterNonTxn.runTest(3, 100);
    }

    @Test
    public void bpt_rewrite_99() {
        TestBPlusTreeRewriterNonTxn.runTest(5, 1000);
    }

    static void runTest(int order, int N) {
        TestBPlusTreeRewriterNonTxn.runOneTest(order, N, recordFactory, false);
    }

    public static void runOneTest(int order, int N, RecordFactory recordFactory, boolean debug) {
        BPlusTreeParams bptParams = new BPlusTreeParams(order, recordFactory);
        BPlusTreeRewriter.debug = debug;
        List<Record> originaldata = TestBPlusTreeRewriterNonTxn.createData(N, recordFactory);
        if (debug) {
            System.out.println("Test data: " + originaldata);
        }
        FileSet destination = FileSet.mem();
        BufferChannel rootState = FileFactory.createBufferChannel((FileSet)destination, (String)"bpt");
        BlockMgr blkMgr1 = BlockMgrFactory.create((FileSet)destination, (String)"idn", (int)bptParams.getCalcBlockSize(), (int)10, (int)10);
        BlockMgr blkMgr2 = BlockMgrFactory.create((FileSet)destination, (String)"idn", (int)bptParams.getCalcBlockSize(), (int)10, (int)10);
        BPlusTree bpt2 = BPlusTreeRewriter.packIntoBPlusTree(originaldata.iterator(), (BPlusTreeParams)bptParams, (RecordFactory)recordFactory, (BufferChannel)rootState, (BlockMgr)blkMgr1, (BlockMgr)blkMgr2);
        if (debug) {
            BPlusTreeRewriterUtils.divider();
            bpt2.dump();
        }
        bpt2.check();
        TestBPlusTreeRewriterNonTxn.scanComparision(originaldata, bpt2);
        TestBPlusTreeRewriterNonTxn.findComparison(originaldata, bpt2);
        TestBPlusTreeRewriterNonTxn.sizeComparison(originaldata, bpt2);
    }

    public static void scanComparision(List<Record> originaldata, BPlusTree bpt2) {
        Iterator<Record> iter1 = originaldata.iterator();
        Iterator iter2 = bpt2.iterator();
        long count = 0L;
        while (iter1.hasNext()) {
            Record r2;
            ++count;
            Record r1 = iter1.next();
            if (!iter2.hasNext()) {
                TestBPlusTreeRewriterNonTxn.error("Deviation: new B+Tree is smaller", new Object[0]);
            }
            if (Record.equals((Record)r1, (Record)(r2 = (Record)iter2.next()))) continue;
            TestBPlusTreeRewriterNonTxn.error("Deviation in iteration record %d: %s : %s", count, r1, r2);
        }
        if (iter2.hasNext()) {
            TestBPlusTreeRewriterNonTxn.error("New B+Tree larger than original", new Object[0]);
        }
    }

    public static void findComparison(List<Record> originaldata, BPlusTree bpt2) {
        Iterator<Record> iter1 = originaldata.iterator();
        long count = 0L;
        while (iter1.hasNext()) {
            ++count;
            Record r1 = iter1.next();
            Record r3 = bpt2.find(r1);
            if (r3 == null) {
                r3 = bpt2.find(r1);
                TestBPlusTreeRewriterNonTxn.error("Deviation in find at record %d: %s : null", count, r1);
            }
            if (Record.equals((Record)r1, (Record)r3)) continue;
            TestBPlusTreeRewriterNonTxn.error("Deviation in find at record %d: %s : %s", count, r1, r3);
        }
    }

    public static void sizeComparison(List<Record> originaldata, BPlusTree bpt2) {
        long count2;
        long count1 = originaldata.size();
        if (count1 != (count2 = bpt2.size())) {
            System.err.println("**** DIFFERENT");
        }
    }

    static List<Record> createData(int N, RecordFactory recordFactory) {
        ArrayList<Record> originaldata = new ArrayList<Record>(N);
        for (int i = 0; i < N; ++i) {
            Record record = recordFactory.create();
            Bytes.setInt((int)(i + 1), (byte[])record.getKey());
            if (recordFactory.hasValue()) {
                Bytes.setInt((int)(10 * i + 1), (byte[])record.getValue());
            }
            originaldata.add(record);
        }
        return originaldata;
    }

    private static void error(String string, Object ... args) {
        String msg = String.format(string, args);
        System.err.println(msg);
        throw new BPTreeException(msg);
    }
}

