/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.dboe.trans.data;

import org.apache.jena.atlas.lib.Bytes;
import org.apache.jena.atlas.lib.StrUtils;
import org.apache.jena.dboe.base.file.BinaryDataFile;
import org.apache.jena.dboe.base.file.BinaryDataFileMem;
import org.apache.jena.dboe.base.file.BufferChannel;
import org.apache.jena.dboe.base.file.FileFactory;
import org.apache.jena.dboe.base.file.Location;
import org.apache.jena.dboe.trans.data.TransBinaryDataFile;
import org.apache.jena.dboe.transaction.TransactionalFactory;
import org.apache.jena.dboe.transaction.txn.ComponentId;
import org.apache.jena.dboe.transaction.txn.TransactionalComponent;
import org.apache.jena.dboe.transaction.txn.journal.Journal;
import org.apache.jena.sparql.core.Transactional;
import org.apache.jena.system.ThreadTxn;
import org.apache.jena.system.Txn;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestTransBinaryDataFile {
    private Journal journal;
    private BinaryDataFile baseBinData;
    private TransBinaryDataFile transBinData;
    private org.apache.jena.dboe.transaction.Transactional transactional;
    static byte[] bytes0 = new byte[0];
    static int len0 = 0;
    static byte[] bytes1 = new byte[]{1, 2, 3};
    static int len1 = bytes1.length;
    static byte[] bytes2 = StrUtils.asUTF8bytes((String)"TheNext");
    static int len2 = bytes2.length;

    @Before
    public void before() {
        this.journal = Journal.create((Location)Location.mem());
        this.baseBinData = new BinaryDataFileMem();
        BufferChannel chan = FileFactory.createBufferChannelMem();
        ComponentId cid = ComponentId.allocLocal();
        this.transBinData = new TransBinaryDataFile(this.baseBinData, cid, chan);
        this.transBinData.open();
        this.transactional = TransactionalFactory.createTransactional((Journal)this.journal, (TransactionalComponent[])new TransactionalComponent[]{this.transBinData});
    }

    @After
    public void after() {
    }

    private static long writeOne(org.apache.jena.dboe.transaction.Transactional transactional, TransBinaryDataFile transBinaryFile, String data) {
        return (Long)Txn.calculateWrite((Transactional)transactional, () -> {
            byte[] bytes = StrUtils.asUTF8bytes((String)data);
            int len = bytes.length;
            byte[] lenBytes = new byte[4];
            Bytes.setInt((int)len, (byte[])lenBytes);
            long x = transBinaryFile.write(lenBytes);
            transBinaryFile.write(bytes);
            return x;
        });
    }

    private static String readOne(org.apache.jena.dboe.transaction.Transactional transactional, TransBinaryDataFile transBinaryFile, long posn) {
        return (String)Txn.calculateRead((Transactional)transactional, () -> {
            byte[] lenBytes = new byte[4];
            long x = posn;
            int got = transBinaryFile.read(x, lenBytes);
            x += (long)got;
            int len = Bytes.getInt((byte[])lenBytes);
            byte[] bytes = new byte[len];
            got = transBinaryFile.read(x, bytes);
            x += (long)got;
            return StrUtils.fromUTF8bytes((byte[])bytes);
        });
    }

    @Test
    public void transObjectFile_str1() {
        String str = "Hello World";
        long x = TestTransBinaryDataFile.writeOne(this.transactional, this.transBinData, str);
        String str2 = TestTransBinaryDataFile.readOne(this.transactional, this.transBinData, x);
        Assert.assertEquals((Object)str, (Object)str2);
    }

    @Test
    public void transObjectFile_str2() {
        String str1 = "";
        String str2 = "$";
        long x1 = TestTransBinaryDataFile.writeOne(this.transactional, this.transBinData, str1);
        long x2 = TestTransBinaryDataFile.writeOne(this.transactional, this.transBinData, str2);
        Assert.assertNotEquals((String)("(" + x1 + "," + x2 + ")"), (long)x1, (long)x2);
        String out2 = TestTransBinaryDataFile.readOne(this.transactional, this.transBinData, x2);
        String out1 = TestTransBinaryDataFile.readOne(this.transactional, this.transBinData, x1);
        Assert.assertEquals((Object)str1, (Object)out1);
        Assert.assertEquals((Object)str2, (Object)out2);
    }

    @Test
    public void transObjectFile_1() {
        Txn.executeWrite((Transactional)this.transactional, () -> {
            long x = this.transBinData.write(bytes1);
            Assert.assertEquals((long)0L, (long)x);
            Assert.assertEquals((long)len1, (long)this.transBinData.length());
        });
    }

    @Test
    public void transObjectFile_2() {
        Txn.executeWrite((Transactional)this.transactional, () -> {
            long x = this.transBinData.write(bytes1);
            Assert.assertEquals((long)0L, (long)x);
            Assert.assertEquals((long)len1, (long)this.transBinData.length());
            byte[] bytes1a = new byte[len1];
            int len = this.transBinData.read(0L, bytes1a);
            Assert.assertEquals((long)len1, (long)len);
            Assert.assertArrayEquals((byte[])bytes1, (byte[])bytes1a);
        });
    }

    @Test
    public void transObjectFile_3() {
        Txn.executeWrite((Transactional)this.transactional, () -> {
            long x1 = this.transBinData.write(bytes1);
            long x2 = this.transBinData.write(bytes2);
            byte[] bytes1a = new byte[len1];
            byte[] bytes2a = new byte[len2];
            int len1a = this.transBinData.read(0L, bytes1a);
            int len2a = this.transBinData.read((long)len1a, bytes2a);
            Assert.assertEquals((long)len1, (long)len1a);
            Assert.assertArrayEquals((byte[])bytes1, (byte[])bytes1a);
            Assert.assertEquals((long)len2, (long)len2a);
            Assert.assertArrayEquals((byte[])bytes2, (byte[])bytes2a);
        });
    }

    @Test
    public void transObjectFile_4() {
        Txn.executeWrite((Transactional)this.transactional, () -> {
            long x1 = this.transBinData.write(bytes1);
            long x2 = this.transBinData.write(bytes2);
        });
        Txn.executeRead((Transactional)this.transactional, () -> {
            byte[] bytes1a = new byte[len1];
            byte[] bytes2a = new byte[len2];
            int len1a = this.transBinData.read(0L, bytes1a);
            int len2a = this.transBinData.read((long)len1a, bytes2a);
            Assert.assertEquals((long)len1, (long)len1a);
            Assert.assertArrayEquals((byte[])bytes1, (byte[])bytes1a);
            Assert.assertEquals((long)len2, (long)len2a);
            Assert.assertArrayEquals((byte[])bytes2, (byte[])bytes2a);
        });
    }

    @Test
    public void transObjectFile_5() {
        Txn.executeWrite((Transactional)this.transactional, () -> {
            long x1 = this.transBinData.write(bytes1);
            long x2 = this.transBinData.write(bytes2);
        });
        Txn.executeRead((Transactional)this.transactional, () -> {
            byte[] bytes1a = new byte[len1];
            byte[] bytes2a = new byte[len2];
            int len2a = this.transBinData.read((long)len1, bytes2a);
            int len1a = this.transBinData.read(0L, bytes1a);
            Assert.assertEquals((long)len1, (long)len1a);
            Assert.assertArrayEquals((byte[])bytes1, (byte[])bytes1a);
            Assert.assertEquals((long)len2, (long)len2a);
            Assert.assertArrayEquals((byte[])bytes2, (byte[])bytes2a);
        });
    }

    @Test
    public void transObjectFile_6() {
        Txn.executeWrite((Transactional)this.transactional, () -> {
            long x1 = this.transBinData.write(bytes1);
            long x2 = this.transBinData.write(bytes2);
        });
        Txn.executeRead((Transactional)this.transactional, () -> {
            byte[] bytes2a = new byte[len2];
            int len2a = this.transBinData.read((long)len1, bytes2a);
            Assert.assertEquals((long)len2, (long)len2a);
            Assert.assertArrayEquals((byte[])bytes2, (byte[])bytes2a);
        });
    }

    @Test
    public void transObjectFile_7() {
        ThreadTxn.threadTxnWriteAbort((Transactional)this.transactional, () -> {
            long x1 = this.transBinData.write(bytes1);
        }).run();
        Txn.executeRead((Transactional)this.transactional, () -> Assert.assertEquals((long)0L, (long)this.transBinData.length()));
    }
}

