/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.dboe.trans.data;

import java.util.concurrent.atomic.AtomicReference;
import org.apache.jena.dboe.base.file.BufferChannel;
import org.apache.jena.dboe.base.file.BufferChannelMem;
import org.apache.jena.dboe.base.file.Location;
import org.apache.jena.dboe.trans.data.TransBlob;
import org.apache.jena.dboe.transaction.TransactionalFactory;
import org.apache.jena.dboe.transaction.txn.ComponentId;
import org.apache.jena.dboe.transaction.txn.TransactionalComponent;
import org.apache.jena.dboe.transaction.txn.journal.Journal;
import org.apache.jena.query.ReadWrite;
import org.apache.jena.sparql.core.Transactional;
import org.apache.jena.system.ThreadAction;
import org.apache.jena.system.ThreadTxn;
import org.apache.jena.system.Txn;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestTransBlob
extends Assert {
    private Journal journal;
    private TransBlob transBlob;
    private org.apache.jena.dboe.transaction.Transactional transactional;

    @Before
    public void before() {
        this.journal = Journal.create((Location)Location.mem());
        BufferChannel chan = BufferChannelMem.create((String)"TestTransBlob");
        ComponentId cid = ComponentId.allocLocal();
        this.transBlob = new TransBlob(cid, chan);
        this.transactional = TransactionalFactory.createTransactional((Journal)this.journal, (TransactionalComponent[])new TransactionalComponent[]{this.transBlob});
    }

    @After
    public void after() {
    }

    public static void write(org.apache.jena.dboe.transaction.Transactional transactional, TransBlob transBlob, String data) {
        Txn.executeWrite((Transactional)transactional, () -> transBlob.setString(data));
    }

    public static String read(org.apache.jena.dboe.transaction.Transactional transactional, TransBlob transBlob) {
        return (String)Txn.calculateRead((Transactional)transactional, () -> transBlob.getString());
    }

    void threadRead(String expected) {
        AtomicReference result = new AtomicReference();
        ThreadTxn.threadTxnRead((Transactional)this.transactional, () -> {
            String s = this.transBlob.getString();
            result.set(s);
        }).run();
        Assert.assertEquals((Object)expected, result.get());
    }

    @Test
    public void transBlob_1() {
        String str = "Hello World";
        TestTransBlob.write(this.transactional, this.transBlob, str);
        String str2 = TestTransBlob.read(this.transactional, this.transBlob);
        TestTransBlob.assertEquals((Object)str, (Object)str2);
        String str3 = this.transBlob.getString();
        TestTransBlob.assertEquals((Object)str, (Object)str3);
    }

    @Test
    public void transBlob_2() {
        String str1 = "one";
        String str2 = "two";
        TestTransBlob.write(this.transactional, this.transBlob, str1);
        this.transactional.begin(ReadWrite.WRITE);
        this.transBlob.setString(str2);
        this.threadRead(str1);
        this.transactional.commit();
        this.transactional.end();
        this.threadRead(str2);
    }

    @Test
    public void transBlob_3() {
        String str1 = "one";
        String str2 = "two";
        TestTransBlob.write(this.transactional, this.transBlob, str1);
        String s1 = this.transBlob.getString();
        TestTransBlob.assertEquals((Object)str1, (Object)s1);
        String s2 = TestTransBlob.read(this.transactional, this.transBlob);
        TestTransBlob.assertEquals((Object)str1, (Object)s2);
        ThreadAction tt = ThreadTxn.threadTxnRead((Transactional)this.transactional, () -> {
            String sr = this.transBlob.getString();
            Assert.assertEquals((Object)str1, (Object)sr);
        });
        TestTransBlob.write(this.transactional, this.transBlob, str2);
        Txn.executeWrite((Transactional)this.transactional, () -> {
            this.transBlob.setString(str2);
            String s = this.transBlob.getString();
            TestTransBlob.assertEquals((Object)str2, (Object)s);
        });
        tt.run();
    }
}

