/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.hadoop.rdf.io.input;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.lib.input.FileInputFormat;
import org.apache.hadoop.mapreduce.lib.input.NLineInputFormat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractNLineFileInputFormat<TKey, TValue>
extends FileInputFormat<TKey, TValue> {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractNLineFileInputFormat.class);

    public final List<InputSplit> getSplits(JobContext job) throws IOException {
        boolean debug = LOGGER.isDebugEnabled();
        if (debug && FileInputFormat.getInputDirRecursive((JobContext)job)) {
            LOGGER.debug("Recursive searching for input data is enabled");
        }
        ArrayList<InputSplit> splits = new ArrayList<InputSplit>();
        int numLinesPerSplit = NLineInputFormat.getNumLinesPerSplit((JobContext)job);
        for (FileStatus status : this.listStatus(job)) {
            if (debug) {
                LOGGER.debug("Determining how to split input file/directory {}", (Object)status.getPath());
            }
            splits.addAll(NLineInputFormat.getSplitsForFile((FileStatus)status, (Configuration)job.getConfiguration(), (int)numLinesPerSplit));
        }
        return splits;
    }
}

