/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.hadoop.rdf.io.input.readers;

import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.compress.CompressionCodec;
import org.apache.hadoop.io.compress.CompressionCodecFactory;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.lib.input.FileSplit;
import org.apache.hadoop.util.LineReader;
import org.apache.jena.hadoop.rdf.io.input.util.RdfIOUtils;
import org.apache.jena.hadoop.rdf.types.AbstractNodeTupleWritable;
import org.apache.jena.riot.system.ParserProfile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractLineBasedNodeTupleReader<TValue, T extends AbstractNodeTupleWritable<TValue>>
extends RecordReader<LongWritable, T> {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractLineBasedNodeTupleReader.class);
    private CompressionCodecFactory compressionCodecs = null;
    private long start;
    private long pos;
    private long end;
    private long estLength;
    private int maxLineLength;
    private LineReader in;
    private LongWritable key = null;
    private Text value = null;
    private T tuple = null;
    private ParserProfile profile = null;
    private boolean ignoreBadTuples = true;

    public final void initialize(InputSplit genericSplit, TaskAttemptContext context) throws IOException, InterruptedException {
        LOG.debug("initialize({}, {})", (Object)genericSplit, (Object)context);
        if (!(genericSplit instanceof FileSplit)) {
            throw new IOException("This record reader only supports FileSplit inputs");
        }
        FileSplit split = (FileSplit)genericSplit;
        this.profile = RdfIOUtils.createParserProfile((JobContext)context, split.getPath());
        Configuration config = context.getConfiguration();
        this.ignoreBadTuples = config.getBoolean("rdf.io.input.ignore-bad-tuples", true);
        if (this.ignoreBadTuples) {
            LOG.warn("Configured to ignore bad tuples, parsing errors will be logged and the bad line skipped but no errors will be thrownConsider setting {} to false to disable this behaviour", (Object)"rdf.io.input.ignore-bad-tuples");
        }
        this.maxLineLength = config.getInt("mapreduce.input.linerecordreader.line.maxlength", Integer.MAX_VALUE);
        this.start = split.getStart();
        this.end = this.start + split.getLength();
        Path file = split.getPath();
        long totalLength = file.getFileSystem(context.getConfiguration()).getFileStatus(file).getLen();
        this.compressionCodecs = new CompressionCodecFactory(config);
        CompressionCodec codec = this.compressionCodecs.getCodec(file);
        LOG.info(String.format("Got split with start %d and length %d for file with total length of %d", this.start, split.getLength(), totalLength));
        FileSystem fs = file.getFileSystem(config);
        FSDataInputStream fileIn = fs.open(file);
        boolean skipFirstLine = false;
        if (codec != null) {
            if (totalLength > split.getLength() + 1L) {
                throw new IOException("This record reader can only be used with compressed input where the split covers the whole file");
            }
            this.in = new LineReader((InputStream)codec.createInputStream((InputStream)fileIn), config);
            this.estLength = this.end;
            this.end = Long.MAX_VALUE;
        } else {
            if (this.start != 0L) {
                skipFirstLine = true;
                --this.start;
                fileIn.seek(this.start);
            }
            this.in = new LineReader((InputStream)fileIn, config);
        }
        if (skipFirstLine) {
            this.start += (long)this.in.readLine(new Text(), 0, (int)Math.min(Integer.MAX_VALUE, this.end - this.start));
        }
        this.pos = this.start;
    }

    protected abstract Iterator<TValue> getIterator(String var1, ParserProfile var2);

    protected abstract T createInstance(TValue var1);

    public final boolean nextKeyValue() throws IOException, InterruptedException {
        boolean result;
        if (this.key == null) {
            this.key = new LongWritable();
        }
        if (this.value == null) {
            this.value = new Text();
        }
        this.tuple = null;
        int newSize = 0;
        while (this.pos < this.end && (newSize = this.in.readLine(this.value, this.maxLineLength, Math.max((int)Math.min(Integer.MAX_VALUE, this.end - this.pos), this.maxLineLength))) != 0) {
            this.key.set(this.pos);
            this.pos += (long)newSize;
            if (this.pos > this.estLength) {
                this.estLength = this.pos + 1L;
            }
            if (newSize >= this.maxLineLength) {
                LOG.warn("Skipped oversized line of size {} at position {}", (Object)newSize, (Object)(this.pos - (long)newSize));
                continue;
            }
            try {
                Iterator<TValue> iter = this.getIterator(this.value.toString(), this.profile);
                if (iter.hasNext()) {
                    this.tuple = this.createInstance(iter.next());
                    break;
                }
                LOG.debug("Valid line with no triple at position {}", (Object)(this.pos - (long)newSize));
            }
            catch (Throwable e) {
                LOG.error("Bad tuple at position " + (this.pos - (long)newSize), e);
                if (this.ignoreBadTuples) continue;
                throw new IOException(String.format("Bad tuple at position %d", this.pos - (long)newSize), e);
            }
        }
        boolean bl = result = this.tuple != null;
        if (newSize == 0) {
            this.key = null;
            this.value = null;
            this.tuple = null;
            result = false;
            this.estLength = this.pos;
        }
        LOG.debug("nextKeyValue() --> {}", (Object)result);
        return result;
    }

    public LongWritable getCurrentKey() throws IOException, InterruptedException {
        LOG.debug("getCurrentKey() --> {}", (Object)this.key);
        return this.key;
    }

    public T getCurrentValue() throws IOException, InterruptedException {
        LOG.debug("getCurrentValue() --> {}", this.tuple);
        return this.tuple;
    }

    public float getProgress() throws IOException, InterruptedException {
        float progress = 0.0f;
        if (this.start != this.end) {
            if (this.end == Long.MAX_VALUE) {
                if (this.estLength == 0L) {
                    return 1.0f;
                }
                progress = Math.min(1.0f, (float)(this.pos - this.start) / (float)(this.estLength - this.start));
            } else {
                progress = Math.min(1.0f, (float)(this.pos - this.start) / (float)(this.end - this.start));
            }
        }
        LOG.debug("getProgress() --> {}", (Object)Float.valueOf(progress));
        return progress;
    }

    public void close() throws IOException {
        LOG.debug("close()");
        if (this.in != null) {
            this.in.close();
        }
    }
}

