/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.hadoop.rdf.io.input.readers;

import java.io.IOException;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.lib.input.FileSplit;
import org.apache.jena.hadoop.rdf.types.AbstractNodeTupleWritable;
import org.apache.jena.riot.Lang;
import org.apache.jena.riot.RDFLanguages;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractRdfReader<TValue, T extends AbstractNodeTupleWritable<TValue>>
extends RecordReader<LongWritable, T> {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractRdfReader.class);
    private RecordReader<LongWritable, T> reader;

    public void initialize(InputSplit genericSplit, TaskAttemptContext context) throws IOException, InterruptedException {
        LOG.debug("initialize({}, {})", (Object)genericSplit, (Object)context);
        if (!(genericSplit instanceof FileSplit)) {
            throw new IOException("This record reader only supports FileSplit inputs");
        }
        FileSplit split = (FileSplit)genericSplit;
        Path path = split.getPath();
        Lang lang = RDFLanguages.filenameToLang((String)path.getName());
        if (lang == null) {
            throw new IOException("There is no registered RDF language for the input file " + path.toString());
        }
        this.reader = this.selectRecordReader(lang);
        this.reader.initialize((InputSplit)split, context);
    }

    protected abstract RecordReader<LongWritable, T> selectRecordReader(Lang var1) throws IOException;

    public final boolean nextKeyValue() throws IOException, InterruptedException {
        return this.reader.nextKeyValue();
    }

    public final LongWritable getCurrentKey() throws IOException, InterruptedException {
        return (LongWritable)this.reader.getCurrentKey();
    }

    public final T getCurrentValue() throws IOException, InterruptedException {
        return (T)((AbstractNodeTupleWritable)this.reader.getCurrentValue());
    }

    public final float getProgress() throws IOException, InterruptedException {
        return this.reader.getProgress();
    }

    public final void close() throws IOException {
        this.reader.close();
    }
}

