/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.hadoop.rdf.io.input.readers;

import com.hp.hpl.jena.sparql.core.Quad;
import java.io.IOException;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.jena.hadoop.rdf.io.input.readers.AbstractRdfReader;
import org.apache.jena.hadoop.rdf.io.registry.HadoopRdfIORegistry;
import org.apache.jena.hadoop.rdf.types.QuadWritable;
import org.apache.jena.riot.Lang;
import org.apache.jena.riot.RDFLanguages;

public class QuadsReader
extends AbstractRdfReader<Quad, QuadWritable> {
    @Override
    protected RecordReader<LongWritable, QuadWritable> selectRecordReader(Lang lang) throws IOException {
        if (!RDFLanguages.isQuads((Lang)lang)) {
            throw new IOException(lang.getLabel() + " is not a RDF quads format, perhaps you wanted TriplesInputFormat or TriplesOrQuadsInputFormat instead?");
        }
        return HadoopRdfIORegistry.createQuadReader(lang);
    }
}

