/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.hadoop.rdf.io.input.readers;

import com.hp.hpl.jena.graph.Triple;
import java.io.IOException;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.jena.hadoop.rdf.io.input.readers.AbstractRdfReader;
import org.apache.jena.hadoop.rdf.io.registry.HadoopRdfIORegistry;
import org.apache.jena.hadoop.rdf.types.TripleWritable;
import org.apache.jena.riot.Lang;
import org.apache.jena.riot.RDFLanguages;

public class TriplesReader
extends AbstractRdfReader<Triple, TripleWritable> {
    @Override
    protected RecordReader<LongWritable, TripleWritable> selectRecordReader(Lang lang) throws IOException {
        if (!RDFLanguages.isTriples((Lang)lang)) {
            throw new IOException(lang.getLabel() + " is not a RDF triples format, perhaps you wanted QuadsInputFormat or TriplesOrQuadsInputFormat instead?");
        }
        return HadoopRdfIORegistry.createTripleReader(lang);
    }
}

