/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.hadoop.rdf.io.input.readers;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.sparql.core.Quad;
import java.io.IOException;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.jena.hadoop.rdf.types.QuadWritable;
import org.apache.jena.hadoop.rdf.types.TripleWritable;

public class TriplesToQuadsReader
extends RecordReader<LongWritable, QuadWritable> {
    private final RecordReader<LongWritable, TripleWritable> reader;
    private Node graph;

    public TriplesToQuadsReader(RecordReader<LongWritable, TripleWritable> reader) {
        this(reader, Quad.defaultGraphNodeGenerated);
    }

    public TriplesToQuadsReader(RecordReader<LongWritable, TripleWritable> reader, Node graphNode) {
        if (reader == null) {
            throw new NullPointerException("reader cannot be null");
        }
        if (graphNode == null) {
            throw new NullPointerException("Graph node cannot be null");
        }
        this.reader = reader;
        this.graph = graphNode;
    }

    public void initialize(InputSplit split, TaskAttemptContext context) throws IOException, InterruptedException {
        this.reader.initialize(split, context);
    }

    public final boolean nextKeyValue() throws IOException, InterruptedException {
        return this.reader.nextKeyValue();
    }

    public final LongWritable getCurrentKey() throws IOException, InterruptedException {
        return (LongWritable)this.reader.getCurrentKey();
    }

    public final QuadWritable getCurrentValue() throws IOException, InterruptedException {
        TripleWritable t = (TripleWritable)this.reader.getCurrentValue();
        return new QuadWritable(new Quad(this.graph, (Triple)t.get()));
    }

    public final float getProgress() throws IOException, InterruptedException {
        return this.reader.getProgress();
    }

    public final void close() throws IOException {
        this.reader.close();
    }
}

