/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.hadoop.rdf.io.input.util;

import java.io.IOException;
import java.io.InputStream;
import org.apache.jena.hadoop.rdf.io.input.util.TrackedInputStream;

public final class BlockInputStream
extends TrackedInputStream {
    private long limit = Long.MAX_VALUE;

    public BlockInputStream(InputStream input, long limit) {
        super(input);
        if (limit < 0L) {
            throw new IllegalArgumentException("limit must be >= 0");
        }
        this.limit = limit;
    }

    @Override
    public int read() throws IOException {
        if (this.bytesRead >= this.limit) {
            return -1;
        }
        return super.read();
    }

    @Override
    public int available() throws IOException {
        if (this.bytesRead >= this.limit) {
            return 0;
        }
        return super.available();
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        if (len == 0) {
            return 0;
        }
        if (this.bytesRead >= this.limit) {
            return -1;
        }
        if ((long)len > this.limit - this.bytesRead) {
            len = (int)(this.limit - this.bytesRead);
        }
        return super.read(b, off, len);
    }

    @Override
    public long skip(long n) throws IOException {
        if (n == 0L) {
            return 0L;
        }
        if (this.bytesRead >= this.limit) {
            return -1L;
        }
        if (n > this.limit - this.bytesRead) {
            n = this.limit - this.bytesRead;
        }
        return super.skip(n);
    }
}

