/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.hadoop.rdf.io.input.util;

import java.io.IOException;
import java.io.InputStream;
import org.apache.jena.hadoop.rdf.io.input.util.TrackableInputStream;

public class TrackedInputStream
extends TrackableInputStream {
    protected InputStream input;
    protected long bytesRead = 0L;
    protected long lastMark;

    public TrackedInputStream(InputStream input) {
        if (input == null) {
            throw new NullPointerException("Input cannot be null");
        }
        this.input = input;
    }

    @Override
    public int read() throws IOException {
        int read = this.input.read();
        if (read >= 0) {
            ++this.bytesRead;
        }
        return read;
    }

    @Override
    public long getBytesRead() {
        return this.bytesRead;
    }

    @Override
    public void close() throws IOException {
        this.input.close();
    }

    @Override
    public int available() throws IOException {
        return this.input.available();
    }

    @Override
    public synchronized void mark(int readlimit) {
        this.input.mark(readlimit);
        this.lastMark = this.bytesRead;
    }

    @Override
    public boolean markSupported() {
        return this.input.markSupported();
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        if (len == 0) {
            return 0;
        }
        int read = this.input.read(b, off, len);
        if (read > 0) {
            this.bytesRead += (long)read;
        }
        return read;
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    @Override
    public synchronized void reset() throws IOException {
        this.input.reset();
        this.bytesRead = this.lastMark;
    }

    @Override
    public long skip(long n) throws IOException {
        int read;
        if (n == 0L) {
            return 0L;
        }
        long skipped = 0L;
        byte[] buffer = new byte[16];
        int readSize = Math.min(buffer.length, n > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)n);
        do {
            if ((read = n - skipped > (long)readSize ? this.input.read(buffer, 0, readSize) : this.input.read(buffer, 0, (int)(n - skipped))) <= 0) continue;
            this.bytesRead += (long)read;
            skipped += (long)read;
        } while (skipped < n && read >= 0);
        return skipped;
    }
}

