/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.hadoop.rdf.io.output;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.compress.CompressionCodec;
import org.apache.hadoop.io.compress.GzipCodec;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.RecordWriter;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.lib.output.FileOutputFormat;
import org.apache.hadoop.util.ReflectionUtils;
import org.apache.jena.hadoop.rdf.types.NodeWritable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractNodeOutputFormat<TValue>
extends FileOutputFormat<NodeWritable, TValue> {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractNodeOutputFormat.class);

    public RecordWriter<NodeWritable, TValue> getRecordWriter(TaskAttemptContext context) throws IOException, InterruptedException {
        Configuration config = context.getConfiguration();
        boolean isCompressed = AbstractNodeOutputFormat.getCompressOutput((JobContext)context);
        CompressionCodec codec = null;
        String extension = this.getFileExtension();
        if (isCompressed) {
            Class codecClass = AbstractNodeOutputFormat.getOutputCompressorClass((JobContext)context, GzipCodec.class);
            codec = (CompressionCodec)ReflectionUtils.newInstance((Class)codecClass, (Configuration)config);
            extension = extension + codec.getDefaultExtension();
        }
        Path file = this.getDefaultWorkFile(context, extension);
        LOG.info("Writing output to file " + file);
        FileSystem fs = file.getFileSystem(config);
        if (!isCompressed) {
            FSDataOutputStream fileOut = fs.create(file, false);
            return this.getRecordWriter(new OutputStreamWriter((OutputStream)fileOut), config);
        }
        FSDataOutputStream fileOut = fs.create(file, false);
        return this.getRecordWriter(new OutputStreamWriter((OutputStream)codec.createOutputStream((OutputStream)fileOut)), config);
    }

    protected String getFileExtension() {
        return ".nodes";
    }

    protected abstract RecordWriter<NodeWritable, TValue> getRecordWriter(Writer var1, Configuration var2);
}

