/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.hadoop.rdf.io.output;

import com.hp.hpl.jena.sparql.core.Quad;
import java.io.IOException;
import java.io.Writer;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapreduce.RecordWriter;
import org.apache.jena.hadoop.rdf.io.output.AbstractNodeTupleOutputFormat;
import org.apache.jena.hadoop.rdf.io.output.writers.QuadsToTriplesWriter;
import org.apache.jena.hadoop.rdf.io.registry.HadoopRdfIORegistry;
import org.apache.jena.hadoop.rdf.types.QuadWritable;
import org.apache.jena.riot.Lang;
import org.apache.jena.riot.RDFLanguages;

public abstract class TriplesOrQuadsOutputFormat<TKey>
extends AbstractNodeTupleOutputFormat<TKey, Quad, QuadWritable> {
    @Override
    protected RecordWriter<TKey, QuadWritable> getRecordWriter(Writer writer, Configuration config, Path outputPath) throws IOException {
        Lang lang = RDFLanguages.filenameToLang((String)outputPath.getName());
        if (lang == null) {
            throw new IOException("There is no registered RDF language for the output file " + outputPath.toString());
        }
        if (!RDFLanguages.isQuads((Lang)lang) && !RDFLanguages.isTriples((Lang)lang)) {
            throw new IOException(lang.getName() + " is not a RDF triples/quads format");
        }
        if (HadoopRdfIORegistry.hasQuadWriter(lang)) {
            return HadoopRdfIORegistry.createQuadWriter(lang, writer, config);
        }
        return new QuadsToTriplesWriter(HadoopRdfIORegistry.createTripleWriter(lang, writer, config));
    }
}

