/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.hadoop.rdf.io.output.writers;

import java.io.IOException;
import java.io.Writer;
import org.apache.hadoop.mapreduce.RecordWriter;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.jena.hadoop.rdf.types.AbstractNodeTupleWritable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractBatchedNodeTupleWriter<TKey, TValue, T extends AbstractNodeTupleWritable<TValue>>
extends RecordWriter<TKey, T> {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractBatchedNodeTupleWriter.class);
    private Writer writer;
    private long batchSize;

    protected AbstractBatchedNodeTupleWriter(Writer writer, long batchSize) {
        if (writer == null) {
            throw new NullPointerException("writer cannot be null");
        }
        if (batchSize <= 0L) {
            throw new IllegalArgumentException("batchSize must be >= 1");
        }
        this.writer = writer;
        this.batchSize = batchSize;
    }

    public final void write(TKey key, T value) throws IOException, InterruptedException {
        long size;
        LOG.debug("write({}={})", key, value);
        if (this.add(value) >= this.batchSize && (size = this.writeOutput(this.writer)) > 0L) {
            throw new IOException("Derived implementation failed to empty the current batch after writing");
        }
    }

    protected abstract long add(T var1);

    public void close(TaskAttemptContext context) throws IOException, InterruptedException {
        if (this.writer != null) {
            long size = this.writeOutput(this.writer);
            if (size > 0L) {
                throw new IOException("Derived implementation failed to empty the current batch after writing");
            }
            this.writer.close();
            this.writer = null;
        }
    }

    protected abstract long writeOutput(Writer var1);
}

