/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.hadoop.rdf.io.output.writers;

import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.sparql.graph.GraphFactory;
import java.io.Writer;
import org.apache.jena.hadoop.rdf.io.output.writers.AbstractBatchedNodeTupleWriter;
import org.apache.jena.hadoop.rdf.types.TripleWritable;
import org.apache.jena.riot.Lang;
import org.apache.jena.riot.RDFDataMgr;

public abstract class AbstractBatchedTripleWriter<TKey>
extends AbstractBatchedNodeTupleWriter<TKey, Triple, TripleWritable> {
    private Graph g = GraphFactory.createDefaultGraph();

    protected AbstractBatchedTripleWriter(Writer writer, long batchSize) {
        super(writer, batchSize);
    }

    @Override
    protected final long add(TripleWritable value) {
        this.g.add((Triple)value.get());
        return this.g.size();
    }

    @Override
    protected final long writeOutput(Writer writer) {
        if (this.g.size() == 0) {
            return 0L;
        }
        RDFDataMgr.write((Writer)writer, (Graph)this.g, (Lang)this.getRdfLanguage());
        this.g.clear();
        return this.g.size();
    }

    protected abstract Lang getRdfLanguage();
}

