/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.hadoop.rdf.io.output.writers;

import java.io.IOException;
import java.io.Writer;
import org.apache.hadoop.mapreduce.RecordWriter;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.jena.hadoop.rdf.types.AbstractNodeTupleWritable;
import org.apache.jena.riot.system.StreamRDF;

public abstract class AbstractStreamRdfNodeTupleWriter<TKey, TTuple, TValue extends AbstractNodeTupleWritable<TTuple>>
extends RecordWriter<TKey, TValue> {
    private StreamRDF stream;
    private Writer writer;

    public AbstractStreamRdfNodeTupleWriter(StreamRDF stream, Writer writer) {
        if (stream == null) {
            throw new NullPointerException("stream cannot be null");
        }
        if (writer == null) {
            throw new NullPointerException("writer cannot be null");
        }
        this.stream = stream;
        this.stream.start();
        this.writer = writer;
    }

    public void close(TaskAttemptContext context) throws IOException, InterruptedException {
        this.stream.finish();
        this.writer.close();
    }

    public void write(TKey key, TValue value) throws IOException, InterruptedException {
        this.sendOutput(key, value, this.stream);
    }

    protected abstract void sendOutput(TKey var1, TValue var2, StreamRDF var3);
}

