/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.hadoop.rdf.io.output.writers;

import java.io.IOException;
import java.io.Writer;
import org.apache.hadoop.mapreduce.RecordWriter;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.jena.hadoop.rdf.types.AbstractNodeTupleWritable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractWholeFileNodeTupleWriter<TKey, TValue, T extends AbstractNodeTupleWritable<TValue>>
extends RecordWriter<TKey, T> {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractWholeFileNodeTupleWriter.class);
    private Writer writer;

    protected AbstractWholeFileNodeTupleWriter(Writer writer) {
        if (writer == null) {
            throw new NullPointerException("writer cannot be null");
        }
        this.writer = writer;
    }

    public final void write(TKey key, T value) throws IOException, InterruptedException {
        LOG.debug("write({}={})", key, value);
        this.add(value);
    }

    protected abstract void add(T var1);

    public void close(TaskAttemptContext context) throws IOException, InterruptedException {
        if (this.writer != null) {
            this.writeOutput(this.writer);
            this.writer.close();
            this.writer = null;
        }
    }

    protected abstract void writeOutput(Writer var1);
}

