/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.hadoop.rdf.io.output.writers;

import com.hp.hpl.jena.sparql.core.Quad;
import java.io.IOException;
import org.apache.hadoop.mapreduce.RecordWriter;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.jena.hadoop.rdf.types.QuadWritable;
import org.apache.jena.hadoop.rdf.types.TripleWritable;

public class QuadsToTriplesWriter<TKey>
extends RecordWriter<TKey, QuadWritable> {
    private RecordWriter<TKey, TripleWritable> writer;

    public QuadsToTriplesWriter(RecordWriter<TKey, TripleWritable> tripleWriter) {
        if (tripleWriter == null) {
            throw new NullPointerException("tripleWriter cannot be null");
        }
        this.writer = tripleWriter;
    }

    public void write(TKey key, QuadWritable value) throws IOException, InterruptedException {
        this.writer.write(key, (Object)new TripleWritable(((Quad)value.get()).asTriple()));
    }

    public void close(TaskAttemptContext context) throws IOException, InterruptedException {
        this.writer.close(context);
    }
}

