/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.hadoop.rdf.io.registry;

import java.io.IOException;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import java.util.ServiceLoader;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.RecordWriter;
import org.apache.jena.hadoop.rdf.io.registry.ReaderFactory;
import org.apache.jena.hadoop.rdf.io.registry.WriterFactory;
import org.apache.jena.hadoop.rdf.types.QuadWritable;
import org.apache.jena.hadoop.rdf.types.TripleWritable;
import org.apache.jena.riot.Lang;

public class HadoopRdfIORegistry {
    private static Map<Lang, ReaderFactory> readerFactories = new HashMap<Lang, ReaderFactory>();
    private static Map<Lang, WriterFactory> writerFactories = new HashMap<Lang, WriterFactory>();
    private static boolean init = false;

    private static synchronized void init() {
        if (init) {
            return;
        }
        ServiceLoader<ReaderFactory> readerFactoryLoader = ServiceLoader.load(ReaderFactory.class);
        for (ReaderFactory f : readerFactoryLoader) {
            HadoopRdfIORegistry.addReaderFactory(f);
        }
        ServiceLoader<WriterFactory> writerFactoryLoader = ServiceLoader.load(WriterFactory.class);
        for (WriterFactory f : writerFactoryLoader) {
            HadoopRdfIORegistry.addWriterFactory(f);
        }
        init = true;
    }

    public static synchronized void reset() {
        if (!init) {
            return;
        }
        init = false;
        HadoopRdfIORegistry.init();
    }

    public static void addReaderFactory(ReaderFactory f) {
        if (f == null) {
            throw new NullPointerException("Factory cannot be null");
        }
        readerFactories.put(f.getPrimaryLanguage(), f);
        for (Lang altLang : f.getAlternativeLanguages()) {
            readerFactories.put(altLang, f);
        }
    }

    public static void addWriterFactory(WriterFactory f) {
        if (f == null) {
            throw new NullPointerException("Factory cannot be null");
        }
        writerFactories.put(f.getPrimaryLanguage(), f);
        for (Lang altLang : f.getAlternativeLanguages()) {
            writerFactories.put(altLang, f);
        }
    }

    public static boolean hasQuadReader(Lang lang) {
        if (lang == null) {
            return false;
        }
        ReaderFactory f = readerFactories.get(lang);
        if (f == null) {
            return false;
        }
        return f.canReadQuads();
    }

    public static boolean hasTriplesReader(Lang lang) {
        if (lang == null) {
            return false;
        }
        ReaderFactory f = readerFactories.get(lang);
        if (f == null) {
            return false;
        }
        return f.canReadTriples();
    }

    public static RecordReader<LongWritable, QuadWritable> createQuadReader(Lang lang) throws IOException {
        if (lang == null) {
            throw new IOException("Cannot create a quad reader for an undefined language");
        }
        ReaderFactory f = readerFactories.get(lang);
        if (f == null) {
            throw new IOException("No factory registered for language " + lang.getName());
        }
        if (!f.canReadQuads()) {
            throw new IOException(lang.getName() + " does not support reading quads");
        }
        RecordReader<LongWritable, QuadWritable> reader = f.createQuadReader();
        if (reader == null) {
            throw new IOException("Registered factory for " + lang.getName() + " produced a null triples reader");
        }
        return reader;
    }

    public static RecordReader<LongWritable, TripleWritable> createTripleReader(Lang lang) throws IOException {
        if (lang == null) {
            throw new IOException("Cannot create a triple reader for an undefined language");
        }
        ReaderFactory f = readerFactories.get(lang);
        if (f == null) {
            throw new IOException("No factory registered for language " + lang.getName());
        }
        if (!f.canReadTriples()) {
            throw new IOException(lang.getName() + " does not support reading triples");
        }
        RecordReader<LongWritable, TripleWritable> reader = f.createTripleReader();
        if (reader == null) {
            throw new IOException("Registered factory for " + lang.getName() + " produced a null triples reader");
        }
        return reader;
    }

    public static boolean hasQuadWriter(Lang lang) {
        if (lang == null) {
            return false;
        }
        WriterFactory f = writerFactories.get(lang);
        if (f == null) {
            return false;
        }
        return f.canWriteQuads();
    }

    public static boolean hasTriplesWriter(Lang lang) {
        if (lang == null) {
            return false;
        }
        WriterFactory f = writerFactories.get(lang);
        if (f == null) {
            return false;
        }
        return f.canWriteTriples();
    }

    public static <TKey> RecordWriter<TKey, QuadWritable> createQuadWriter(Lang lang, Writer writer, Configuration config) throws IOException {
        if (lang == null) {
            throw new IOException("Cannot create a quad writer for an undefined language");
        }
        WriterFactory f = writerFactories.get(lang);
        if (f == null) {
            throw new IOException("No factory registered for language " + lang.getName());
        }
        if (!f.canWriteQuads()) {
            throw new IOException(lang.getName() + " does not support writeing quads");
        }
        RecordWriter rwriter = f.createQuadWriter(writer, config);
        if (rwriter == null) {
            throw new IOException("Registered factory for " + lang.getName() + " produced a null triples writer");
        }
        return rwriter;
    }

    public static <TKey> RecordWriter<TKey, TripleWritable> createTripleWriter(Lang lang, Writer writer, Configuration config) throws IOException {
        if (lang == null) {
            throw new IOException("Cannot create a triple writer for an undefined language");
        }
        WriterFactory f = writerFactories.get(lang);
        if (f == null) {
            throw new IOException("No factory registered for language " + lang.getName());
        }
        if (!f.canWriteTriples()) {
            throw new IOException(lang.getName() + " does not support writing triples");
        }
        RecordWriter rwriter = f.createTripleWriter(writer, config);
        if (rwriter == null) {
            throw new IOException("Registered factory for " + lang.getName() + " produced a null triples writer");
        }
        return rwriter;
    }

    static {
        HadoopRdfIORegistry.init();
    }
}

