/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.fuseki.main;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.servlet.Filter;
import javax.servlet.Servlet;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.jena.atlas.lib.Pair;
import org.apache.jena.fuseki.Fuseki;
import org.apache.jena.fuseki.metrics.MetricsProviderRegistry;
import org.apache.jena.fuseki.server.DataAccessPointRegistry;
import org.apache.jena.fuseki.server.OperationRegistry;
import org.apache.jena.web.HttpSC;
import org.eclipse.jetty.http.HttpMethod;
import org.eclipse.jetty.http.MimeTypes;
import org.eclipse.jetty.security.SecurityHandler;
import org.eclipse.jetty.server.ConnectionFactory;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HttpConnectionFactory;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Response;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.server.handler.ErrorHandler;
import org.eclipse.jetty.servlet.DefaultServlet;
import org.eclipse.jetty.servlet.FilterHolder;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JettyServer {
    private static Logger LOG = LoggerFactory.getLogger((String)"HTTP");
    protected final Server server;
    protected int port;

    public static Builder create() {
        return new Builder();
    }

    protected JettyServer(int port, Server server) {
        this.server = server;
        this.port = port;
    }

    public int getPort() {
        return this.port;
    }

    public Server getJettyServer() {
        return this.server;
    }

    public ServletContext getServletContext() {
        return ((ServletContextHandler)this.server.getHandler()).getServletContext();
    }

    public JettyServer start() {
        try {
            this.server.start();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        if (this.port == 0) {
            this.port = ((ServerConnector)this.server.getConnectors()[0]).getLocalPort();
        }
        this.logStart();
        return this;
    }

    protected void logStart() {
        LOG.info("Start (port=" + this.port + ")");
    }

    public void stop() {
        this.logStop();
        try {
            this.server.stop();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected void logStop() {
        LOG.info("Stop (port=" + this.port + ")");
    }

    public void join() {
        try {
            this.server.join();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static class Builder {
        private int port = -1;
        private boolean loopback = false;
        protected boolean verbose = false;
        private List<Pair<String, HttpServlet>> servlets = new ArrayList<Pair<String, HttpServlet>>();
        private List<Pair<String, Filter>> filters = new ArrayList<Pair<String, Filter>>();
        private String contextPath = "/";
        private String servletContextName = "Jetty";
        private String staticContentDir = null;
        private SecurityHandler securityHandler = null;
        private ErrorHandler errorHandler = new PlainErrorHandler();
        private Map<String, Object> servletAttr = new HashMap<String, Object>();

        public Builder port(int port) {
            if (port < 0) {
                throw new IllegalArgumentException("Illegal port=" + port + " : Port must be greater than or equal to zero.");
            }
            this.port = port;
            return this;
        }

        public Builder contextPath(String path) {
            Objects.requireNonNull(path, "path");
            this.contextPath = path;
            return this;
        }

        public Builder servletContextName(String name) {
            Objects.requireNonNull(name, "name");
            this.servletContextName = name;
            return this;
        }

        public Builder loopback(boolean loopback) {
            this.loopback = loopback;
            return this;
        }

        public Builder staticFileBase(String directory) {
            Objects.requireNonNull(directory, "directory");
            this.staticContentDir = directory;
            return this;
        }

        public Builder securityHandler(SecurityHandler securityHandler) {
            Objects.requireNonNull(securityHandler, "securityHandler");
            this.securityHandler = securityHandler;
            return this;
        }

        public Builder errorHandler(ErrorHandler errorHandler) {
            Objects.requireNonNull(errorHandler, "securityHandler");
            this.errorHandler = errorHandler;
            return this;
        }

        public Builder verbose(boolean verbose) {
            this.verbose = verbose;
            return this;
        }

        public Builder addServlet(String pathSpec, HttpServlet servlet) {
            Objects.requireNonNull(pathSpec, "pathSpec");
            Objects.requireNonNull(servlet, "servlet");
            this.servlets.add((Pair<String, HttpServlet>)Pair.create((Object)pathSpec, (Object)servlet));
            return this;
        }

        public Builder addServletAttribute(String attrName, Object value) {
            Objects.requireNonNull(attrName, "attrName");
            if (value != null) {
                this.servletAttr.put(attrName, value);
            } else {
                this.servletAttr.remove(attrName);
            }
            return this;
        }

        public Builder addFilter(String pathSpec, Filter filter) {
            Objects.requireNonNull(pathSpec, "pathSpec");
            Objects.requireNonNull(filter, "filter");
            this.filters.add((Pair<String, Filter>)Pair.create((Object)pathSpec, (Object)filter));
            return this;
        }

        public JettyServer build() {
            ServletContextHandler handler = this.buildServletContext();
            Server server = Builder.jettyServer(this.port, this.loopback);
            server.setHandler((Handler)handler);
            return new JettyServer(this.port, server);
        }

        private ServletContextHandler buildServletContext() {
            ServletContextHandler handler = this.buildServletContext(this.contextPath);
            ContextHandler.Context cxt = handler.getServletContext();
            this.adjustForFuseki((ServletContext)cxt);
            this.servletAttr.forEach((arg_0, arg_1) -> Builder.lambda$buildServletContext$0((ServletContext)cxt, arg_0, arg_1));
            this.servletsAndFilters(handler);
            return handler;
        }

        private void adjustForFuseki(ServletContext cxt) {
            try {
                Fuseki.setVerbose((ServletContext)cxt, (boolean)this.verbose);
                OperationRegistry.set((ServletContext)cxt, (OperationRegistry)OperationRegistry.createEmpty());
                DataAccessPointRegistry.set((ServletContext)cxt, (DataAccessPointRegistry)new DataAccessPointRegistry(MetricsProviderRegistry.get().getMeterRegistry()));
            }
            catch (NoClassDefFoundError err) {
                LOG.info("Fuseki classes not found");
            }
        }

        private ServletContextHandler buildServletContext(String contextPath) {
            if (contextPath == null || contextPath.isEmpty()) {
                contextPath = "/";
            } else if (!contextPath.startsWith("/")) {
                contextPath = "/" + contextPath;
            }
            ServletContextHandler context = new ServletContextHandler();
            context.setDisplayName(this.servletContextName);
            context.setErrorHandler(this.errorHandler);
            context.setContextPath(contextPath);
            if (this.securityHandler != null) {
                context.setSecurityHandler(this.securityHandler);
            }
            return context;
        }

        private void servletsAndFilters(ServletContextHandler context) {
            this.servlets.forEach(p -> Builder.addServlet(context, (String)p.getLeft(), (HttpServlet)p.getRight()));
            this.filters.forEach(p -> this.addFilter(context, (String)p.getLeft(), (Filter)p.getRight()));
            if (this.staticContentDir != null) {
                DefaultServlet staticServlet = new DefaultServlet();
                ServletHolder staticContent = new ServletHolder((Servlet)staticServlet);
                staticContent.setInitParameter("resourceBase", this.staticContentDir);
                context.addServlet(staticContent, "/");
            }
        }

        protected static void addServlet(ServletContextHandler context, String pathspec, HttpServlet httpServlet) {
            ServletHolder sh = new ServletHolder((Servlet)httpServlet);
            context.addServlet(sh, pathspec);
        }

        protected void addFilter(ServletContextHandler context, String pathspec, Filter filter) {
            FilterHolder h = new FilterHolder(filter);
            context.addFilter(h, pathspec, null);
        }

        private static Server jettyServer(int port, boolean loopback) {
            Server server = new Server();
            HttpConnectionFactory f1 = new HttpConnectionFactory();
            f1.getHttpConfiguration().setSendServerVersion(false);
            ServerConnector connector = new ServerConnector(server, new ConnectionFactory[]{f1});
            connector.setPort(port);
            server.addConnector((Connector)connector);
            if (loopback) {
                connector.setHost("localhost");
            }
            return server;
        }

        private static /* synthetic */ void lambda$buildServletContext$0(ServletContext cxt, String n, Object v) {
            cxt.setAttribute(n, v);
        }
    }

    public static class PlainErrorHandler
    extends ErrorHandler {
        public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException {
            String method = request.getMethod();
            if (!(method.equals(HttpMethod.GET.asString()) || method.equals(HttpMethod.POST.asString()) || method.equals(HttpMethod.HEAD.asString()))) {
                return;
            }
            response.setContentType(MimeTypes.Type.TEXT_PLAIN_UTF_8.asString());
            response.setHeader("Cache-Control", "must-revalidate,no-cache,no-store");
            response.setHeader("Pragma", "no-cache");
            int code = response.getStatus();
            String message = response instanceof Response ? ((Response)response).getReason() : HttpSC.getMessage((int)code);
            response.getOutputStream().print(String.format("Error %d: %s\n", code, message));
        }
    }
}

