/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.fuseki.main.cmds;

import arq.cmdline.CmdARQ;
import arq.cmdline.ModAssembler;
import arq.cmdline.ModDatasetAssembler;
import java.net.BindException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Iterator;
import java.util.List;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServlet;
import org.apache.jena.assembler.exceptions.AssemblerException;
import org.apache.jena.atlas.lib.FileOps;
import org.apache.jena.atlas.logging.FmtLog;
import org.apache.jena.atlas.web.AuthScheme;
import org.apache.jena.cmd.ArgDecl;
import org.apache.jena.cmd.ArgModuleGeneral;
import org.apache.jena.cmd.CmdException;
import org.apache.jena.cmd.TerminationException;
import org.apache.jena.fuseki.Fuseki;
import org.apache.jena.fuseki.FusekiException;
import org.apache.jena.fuseki.main.FusekiServer;
import org.apache.jena.fuseki.main.cmds.DSGSetup;
import org.apache.jena.fuseki.main.cmds.ServerConfig;
import org.apache.jena.fuseki.server.DataAccessPoint;
import org.apache.jena.fuseki.server.DataAccessPointRegistry;
import org.apache.jena.fuseki.server.FusekiInfo;
import org.apache.jena.fuseki.servlets.SPARQL_QueryGeneral;
import org.apache.jena.fuseki.validation.DataValidator;
import org.apache.jena.fuseki.validation.IRIValidator;
import org.apache.jena.fuseki.validation.QueryValidator;
import org.apache.jena.fuseki.validation.UpdateValidator;
import org.apache.jena.graph.Graph;
import org.apache.jena.query.ARQ;
import org.apache.jena.query.Dataset;
import org.apache.jena.rdfs.RDFSFactory;
import org.apache.jena.riot.Lang;
import org.apache.jena.riot.RDFDataMgr;
import org.apache.jena.riot.RDFLanguages;
import org.apache.jena.riot.RiotException;
import org.apache.jena.sparql.core.DatasetGraph;
import org.apache.jena.sparql.core.DatasetGraphFactory;
import org.apache.jena.sparql.core.Transactional;
import org.apache.jena.sys.JenaSystem;
import org.apache.jena.system.Txn;
import org.slf4j.Logger;

public class FusekiMain
extends CmdARQ {
    private static int defaultPort = 3030;
    private static int defaultHttpsPort = 3043;
    private static ArgDecl argMem = new ArgDecl(false, new String[]{"mem"});
    private static ArgDecl argUpdate = new ArgDecl(false, new String[]{"update", "allowUpdate"});
    private static ArgDecl argFile = new ArgDecl(true, new String[]{"file"});
    private static ArgDecl argTDB1mode = new ArgDecl(false, new String[]{"tdb1"});
    private static ArgDecl argTDB2mode = new ArgDecl(false, new String[]{"tdb2"});
    private static ArgDecl argMemTDB = new ArgDecl(false, new String[]{"memtdb", "memTDB", "tdbmem"});
    private static ArgDecl argTDB = new ArgDecl(true, new String[]{"loc", "location", "tdb"});
    private static ArgDecl argRDFS = new ArgDecl(true, new String[]{"rdfs"});
    private static ArgDecl argEmpty = new ArgDecl(false, new String[]{"empty", "no-dataset"});
    private static ArgDecl argGeneralQuerySvc = new ArgDecl(true, new String[]{"general"});
    private static ArgDecl argPort = new ArgDecl(true, new String[]{"port"});
    private static ArgDecl argLocalhost = new ArgDecl(false, new String[]{"localhost", "local"});
    private static ArgDecl argTimeout = new ArgDecl(true, new String[]{"timeout"});
    private static ArgDecl argConfig = new ArgDecl(true, new String[]{"config", "conf"});
    private static ArgDecl argJettyConfig = new ArgDecl(true, new String[]{"jetty-config", "jetty"});
    private static ArgDecl argGZip = new ArgDecl(true, new String[]{"gzip"});
    private static ArgDecl argBase = new ArgDecl(true, new String[]{"base", "files"});
    private static ArgDecl argCORS = new ArgDecl(false, new String[]{"withCORS", "cors", "CORS"});
    private static ArgDecl argNoCORS = new ArgDecl(false, new String[]{"noCORS", "no-cors"});
    private static ArgDecl argWithPing = new ArgDecl(false, new String[]{"withPing", "ping"});
    private static ArgDecl argWithStats = new ArgDecl(false, new String[]{"withStats", "stats"});
    private static ArgDecl argWithMetrics = new ArgDecl(false, new String[]{"withMetrics", "metrics"});
    private static ArgDecl argWithCompact = new ArgDecl(false, new String[]{"withCompact", "compact"});
    private static ArgDecl argAuth = new ArgDecl(true, new String[]{"auth"});
    private static ArgDecl argHttps = new ArgDecl(true, new String[]{"https"});
    private static ArgDecl argHttpsPort = new ArgDecl(true, new String[]{"httpsPort", "httpsport", "sport"});
    private static ArgDecl argPasswdFile = new ArgDecl(true, new String[]{"passwd"});
    private static ArgDecl argRealm = new ArgDecl(true, new String[]{"realm"});
    private static ArgDecl argSparqler = new ArgDecl(true, new String[]{"sparqler"});
    private static ArgDecl argValidators = new ArgDecl(false, new String[]{"validators"});
    private static ModDatasetAssembler modDataset = new ModDatasetAssembler();
    private final ServerConfig serverConfig = new ServerConfig();
    private boolean useTDB2 = true;
    static String argUsage = "[--config=FILE] [--mem|--desc=AssemblerFile|--file=FILE] [--port PORT] /DatasetPathName";

    public static FusekiServer build(String ... argv) {
        FusekiMain inner = new FusekiMain(argv);
        inner.process();
        return inner.buildServer();
    }

    static void run(String ... argv) {
        JenaSystem.init();
        new FusekiMain(argv).mainRun();
    }

    protected FusekiMain(String ... argv) {
        super(argv);
        this.getUsage().startCategory("Fuseki Main");
        this.add(argMem, "--mem", "Create an in-memory, non-persistent dataset for the server");
        this.add(argFile, "--file=FILE", "Create an in-memory, non-persistent dataset for the server, initialised with the contents of the file");
        this.add(argTDB2mode, "--tdb2", "Use TDB2 for command line persistent datasets (dfault is TDB1)");
        this.add(argTDB, "--loc=DIR", "Use an existing TDB database (or create if does not exist)");
        this.add(argMemTDB, "--memTDB", "Create an in-memory, non-persistent dataset using TDB (testing only)");
        this.add(argRDFS, "--rdfs=", "Apply RDFS on top of the dataset");
        this.add(argConfig, "--config=", "Use a configuration file to determine the services");
        this.addModule((ArgModuleGeneral)modDataset);
        this.add(argEmpty);
        this.add(argPort, "--port", "Listen on this port number");
        this.add(argLocalhost, "--localhost", "Listen only on the localhost interface");
        this.add(argTimeout, "--timeout=", "Global timeout applied to queries (value in ms) -- format is X[,Y] ");
        this.add(argUpdate, "--update", "Allow updates (via SPARQL Update and SPARQL HTTP Update)");
        this.add(argGZip, "--gzip=on|off", "Enable GZip compression (HTTP Accept-Encoding) if request header set");
        this.add(argBase, "--base=DIR", "Directory for static content");
        this.add(argSparqler, "--sparqler=DIR", "Run with SPARQLer services Directory for static content");
        this.add(argValidators, "--validators", "Install validators");
        this.add(argGeneralQuerySvc, "--general=PATH", "Add a general SPARQL endpoint (without a dataset) at /PATH");
        this.add(argAuth, "--auth=[basic|Digest]", "Run the server using basic or digest authentication (dft: digest).");
        this.add(argHttps, "--https=CONF", "https certificate access details. JSON file { \"cert\":FILE , \"passwd\"; SECRET } ");
        this.add(argHttpsPort, "--httpsPort=NUM", "https port (default port is 3043)");
        this.add(argPasswdFile, "--passwd=FILE", "Password file");
        this.add(argJettyConfig, "--jetty=FILE", "jetty.xml server configuration");
        this.add(argCORS);
        this.add(argNoCORS, "--no-cors", "Disable CORS");
        this.add(argWithPing, "--ping", "Enable /$/ping");
        this.add(argWithStats, "--stats", "Enable /$/stats");
        this.add(argWithMetrics, "--metrics", "Enable /$/metrics");
        this.add(argWithCompact, "--compact", "Enable /$/compact/*");
        this.modVersion.addClass(Fuseki.class);
    }

    protected String getSummary() {
        return this.getCommandName() + " " + argUsage;
    }

    protected void processModulesAndArgs() {
        String filebase;
        boolean allowUpdate;
        Logger log = Fuseki.serverLog;
        this.serverConfig.verboseLogging = super.isVerbose();
        boolean allowEmpty = this.contains(argEmpty) || this.contains(argSparqler);
        int numDefinitions = 0;
        if (this.contains(argMem)) {
            ++numDefinitions;
        }
        if (this.contains(argFile)) {
            ++numDefinitions;
        }
        if (this.contains(ModAssembler.assemblerDescDecl)) {
            ++numDefinitions;
        }
        if (this.contains(argTDB)) {
            ++numDefinitions;
        }
        if (this.contains(argMemTDB)) {
            ++numDefinitions;
        }
        if (this.contains(argConfig)) {
            ++numDefinitions;
        }
        if (numDefinitions == 0 && !allowEmpty) {
            throw new CmdException("No dataset specified on the command line.");
        }
        if (numDefinitions > 1) {
            throw new CmdException("Multiple ways providing a dataset. Only one of --mem, --file, --loc or --conf");
        }
        if (numDefinitions > 0 && allowEmpty) {
            throw new CmdException("Dataset provided but 'no dataset' flag given");
        }
        if (this.contains(argConfig)) {
            if (this.getPositional().size() != 0) {
                throw new CmdException("Can't have both a configutation file and a service name");
            }
            if (this.contains(argRDFS)) {
                throw new CmdException("Need to define RDFS setup in the configuration file.");
            }
        } else {
            if (!allowEmpty && this.getPositional().size() == 0) {
                throw new CmdException("Missing service name");
            }
            if (this.getPositional().size() > 1) {
                throw new CmdException("Multiple dataset path names given");
            }
            if (this.getPositional().size() != 0) {
                this.serverConfig.datasetPath = DataAccessPoint.canonical((String)this.getPositionalArg(0));
            }
        }
        this.serverConfig.datasetDescription = "<unset>";
        if (this.contains(argUpdate) && this.contains(argConfig)) {
            throw new CmdException("--update and a configuration file does not make sense (control using the configuration file only)");
        }
        this.serverConfig.allowUpdate = allowUpdate = this.contains(argUpdate);
        boolean hasJettyConfigFile = this.contains(argJettyConfig);
        this.serverConfig.port = defaultPort;
        if (this.contains(argPort)) {
            if (hasJettyConfigFile) {
                throw new CmdException("Can't specify the port and also provide a Jetty configuration file");
            }
            this.serverConfig.port = this.portNumber(argPort);
        }
        if (this.contains(argLocalhost)) {
            if (hasJettyConfigFile) {
                throw new CmdException("Can't specify 'localhost' and also provide a Jetty configuration file");
            }
            this.serverConfig.loopback = true;
        }
        if (this.contains(argTDB1mode)) {
            this.useTDB2 = false;
        }
        if (this.contains(argTDB2mode)) {
            this.useTDB2 = true;
        }
        if (allowEmpty) {
            this.serverConfig.empty = true;
            this.serverConfig.datasetDescription = "No dataset";
        }
        if (this.contains(argConfig)) {
            Path path;
            String file = this.getValue(argConfig);
            if (file.startsWith("file:")) {
                file = file.substring("file:".length());
            }
            if (!Files.exists(path = Path.of(file, new String[0]), new LinkOption[0])) {
                throw new CmdException("File not found: " + file);
            }
            if (Files.isDirectory(path, new LinkOption[0])) {
                throw new CmdException("Is a directory: " + file);
            }
            this.serverConfig.datasetDescription = "Configuration: " + path.toAbsolutePath();
            this.serverConfig.serverConfig = this.getValue(argConfig);
        }
        if (this.contains(argMem)) {
            this.serverConfig.datasetDescription = "in-memory";
            this.serverConfig.dsg = DatasetGraphFactory.createTxnMem();
            this.serverConfig.allowUpdate = true;
        }
        if (this.contains(argFile)) {
            List filenames = this.getValues(argFile);
            this.serverConfig.datasetDescription = "in-memory, with files loaded";
            this.serverConfig.allowUpdate = this.contains(argUpdate);
            this.serverConfig.dsg = DatasetGraphFactory.createTxnMem();
            Iterator iterator = filenames.iterator();
            while (iterator.hasNext()) {
                String filename;
                String pathname = filename = (String)iterator.next();
                if (filename.startsWith("file:")) {
                    pathname = filename.substring("file:".length());
                }
                if (!FileOps.exists((String)pathname)) {
                    throw new CmdException("File not found: " + filename);
                }
                Lang language = RDFLanguages.filenameToLang((String)filename);
                if (language == null) {
                    throw new CmdException("Can't guess language for file: " + filename);
                }
                Txn.executeWrite((Transactional)this.serverConfig.dsg, () -> {
                    try {
                        log.info("Dataset: in-memory: load file: " + filename);
                        RDFDataMgr.read((DatasetGraph)this.serverConfig.dsg, (String)filename);
                    }
                    catch (RiotException ex) {
                        throw new CmdException("Failed to load file: " + filename);
                    }
                });
            }
        }
        if (this.contains(argMemTDB)) {
            DSGSetup.setupMemTDB(this.useTDB2, this.serverConfig);
        }
        if (this.contains(argTDB)) {
            String directory = this.getValue(argTDB);
            DSGSetup.setupTDB(directory, this.useTDB2, this.serverConfig);
        }
        if (this.contains(ModAssembler.assemblerDescDecl)) {
            this.serverConfig.datasetDescription = "Assembler: " + this.getValue(ModAssembler.assemblerDescDecl);
            Dataset ds = modDataset.createDataset();
            this.serverConfig.dsg = ds.asDatasetGraph();
        }
        if (this.contains(argRDFS)) {
            String rdfsVocab = this.getValue(argRDFS);
            if (!FileOps.exists((String)rdfsVocab)) {
                throw new CmdException("No such file for RDFS: " + rdfsVocab);
            }
            this.serverConfig.rdfsGraph = RDFDataMgr.loadGraph((String)rdfsVocab);
            this.serverConfig.datasetDescription = this.serverConfig.datasetDescription + " (with RDFS)";
            this.serverConfig.dsg = RDFSFactory.datasetRDFS((DatasetGraph)this.serverConfig.dsg, (Graph)this.serverConfig.rdfsGraph);
        }
        if (this.contains(argTimeout)) {
            String str = this.getValue(argTimeout);
            ARQ.getContext().set(ARQ.queryTimeout, (Object)str);
        }
        if (this.contains(argSparqler)) {
            filebase = this.getValue(argSparqler);
            if (!FileOps.exists((String)filebase)) {
                throw new CmdException("File area not found: " + filebase);
            }
            this.serverConfig.contentDirectory = filebase;
            this.serverConfig.addGeneral = "/sparql";
            this.serverConfig.empty = true;
            this.serverConfig.validators = true;
        }
        if (this.contains(argGeneralQuerySvc)) {
            Object z = this.getValue(argGeneralQuerySvc);
            if (!((String)z).startsWith("/")) {
                z = "/" + (String)z;
            }
            this.serverConfig.addGeneral = z;
        }
        if (this.contains(argValidators)) {
            this.serverConfig.validators = true;
        }
        if (this.contains(argBase)) {
            filebase = this.getValue(argBase);
            if (!FileOps.exists((String)filebase)) {
                throw new CmdException("File area not found: " + filebase);
            }
            this.serverConfig.contentDirectory = filebase;
        }
        if (this.contains(argPasswdFile)) {
            if (hasJettyConfigFile) {
                throw new CmdException("Can't specify a password file and also provide a Jetty configuration file");
            }
            this.serverConfig.passwdFile = this.getValue(argPasswdFile);
        }
        if (this.contains(argRealm)) {
            this.serverConfig.realm = this.getValue(argRealm);
        }
        if (this.contains(argHttpsPort) && !this.contains(argHttps)) {
            throw new CmdException("https port given but not certificate details via --" + argHttps.getKeyName());
        }
        if (this.contains(argHttps)) {
            String httpsSetup;
            if (hasJettyConfigFile) {
                throw new CmdException("Can't specify \"https\" and also provide a Jetty configuration file");
            }
            this.serverConfig.httpsPort = defaultHttpsPort;
            if (this.contains(argHttpsPort)) {
                this.serverConfig.httpsPort = this.portNumber(argHttpsPort);
            }
            this.serverConfig.httpsKeysDetails = httpsSetup = this.getValue(argHttps);
        }
        if (this.contains(argAuth)) {
            if (hasJettyConfigFile) {
                throw new CmdException("Can't specify authentication and also provide a Jetty configuration file");
            }
            String schemeStr = this.getValue(argAuth);
            this.serverConfig.authScheme = AuthScheme.scheme((String)schemeStr);
        }
        if (this.contains(argJettyConfig)) {
            String jettyConfigFile = this.getValue(argJettyConfig);
            if (!FileOps.exists((String)jettyConfigFile)) {
                throw new CmdException("Jetty config file not found: " + jettyConfigFile);
            }
            this.serverConfig.jettyConfigFile = jettyConfigFile;
        }
        this.serverConfig.withCORS = !this.contains(argNoCORS);
        this.serverConfig.withPing = this.contains(argWithPing);
        this.serverConfig.withStats = this.contains(argWithStats);
        this.serverConfig.withMetrics = this.contains(argWithMetrics);
        this.serverConfig.withCompact = this.contains(argWithCompact);
    }

    private int portNumber(ArgDecl arg) {
        String portStr = this.getValue(arg);
        if (portStr.isEmpty()) {
            return -1;
        }
        try {
            int port = Integer.parseInt(portStr);
            return port;
        }
        catch (NumberFormatException ex) {
            throw new CmdException(argPort.getKeyName() + " : bad port number: '" + portStr + "'");
        }
    }

    protected void exec() {
        try {
            FusekiServer server = this.buildServer(this.serverConfig);
            this.info(server);
            try {
                server.start();
            }
            catch (FusekiException ex) {
                if (ex.getCause() instanceof BindException) {
                    if (this.serverConfig.jettyConfigFile == null) {
                        Fuseki.serverLog.error("Failed to start server: " + ex.getCause().getMessage() + ": port=" + this.serverConfig.port);
                    } else {
                        Fuseki.serverLog.error("Failed to start server: " + ex.getCause().getMessage() + ": port in use");
                    }
                    System.exit(1);
                }
                throw ex;
            }
            catch (Exception ex) {
                throw new FusekiException("Failed to start server: " + ex.getMessage(), (Throwable)ex);
            }
            server.join();
            System.exit(0);
        }
        catch (AssemblerException | FusekiException ex) {
            if (ex.getCause() != null) {
                System.err.println(ex.getCause().getMessage());
            } else {
                System.err.println(ex.getMessage());
            }
            throw new TerminationException(1);
        }
    }

    private FusekiServer buildServer() {
        return this.buildServer(this.serverConfig);
    }

    private FusekiServer buildServer(ServerConfig serverConfig) {
        FusekiServer.Builder builder = this.builder();
        return FusekiMain.buildServer(builder, serverConfig);
    }

    protected FusekiServer.Builder builder() {
        return FusekiServer.create();
    }

    private static FusekiServer buildServer(FusekiServer.Builder builder, ServerConfig serverConfig) {
        if (serverConfig.jettyConfigFile != null) {
            builder.jettyServerConfig(serverConfig.jettyConfigFile);
        }
        builder.port(serverConfig.port);
        builder.loopback(serverConfig.loopback);
        builder.verbose(serverConfig.verboseLogging);
        if (serverConfig.addGeneral != null) {
            builder.addServlet(serverConfig.addGeneral, (HttpServlet)new SPARQL_QueryGeneral());
        }
        if (serverConfig.validators) {
            builder.addServlet("/$/validate/query", (HttpServlet)new QueryValidator());
            builder.addServlet("/$/validate/update", (HttpServlet)new UpdateValidator());
            builder.addServlet("/$/validate/iri", (HttpServlet)new IRIValidator());
            builder.addServlet("/$/validate/data", (HttpServlet)new DataValidator());
        }
        if (!serverConfig.empty) {
            if (serverConfig.serverConfig != null) {
                builder.parseConfigFile(serverConfig.serverConfig);
            } else {
                builder.add(serverConfig.datasetPath, serverConfig.dsg, serverConfig.allowUpdate);
            }
        }
        if (serverConfig.contentDirectory != null) {
            builder.staticFileBase(serverConfig.contentDirectory);
        }
        if (serverConfig.passwdFile != null) {
            builder.passwordFile(serverConfig.passwdFile);
        }
        if (serverConfig.realm != null) {
            builder.realm(serverConfig.realm);
        }
        if (serverConfig.httpsKeysDetails != null) {
            builder.https(serverConfig.httpsPort, serverConfig.httpsKeysDetails);
        }
        if (serverConfig.authScheme != null) {
            builder.auth(serverConfig.authScheme);
        }
        if (serverConfig.withCORS) {
            builder.enableCors(true);
        }
        if (serverConfig.withPing) {
            builder.enablePing(true);
        }
        if (serverConfig.withStats) {
            builder.enableStats(true);
        }
        if (serverConfig.withMetrics) {
            builder.enableMetrics(true);
        }
        if (serverConfig.withCompact) {
            builder.enableCompact(true);
        }
        return builder.build();
    }

    private void info(FusekiServer server) {
        if (super.isQuiet()) {
            return;
        }
        Logger log = Fuseki.serverLog;
        FusekiInfo.server((Logger)log);
        DataAccessPointRegistry dapRegistry = DataAccessPointRegistry.get((ServletContext)server.getServletContext());
        if (this.serverConfig.empty) {
            FmtLog.info((Logger)log, (String)"No SPARQL datasets services", (Object[])new Object[0]);
        } else if (this.serverConfig.datasetPath == null && this.serverConfig.serverConfig == null) {
            log.error("No dataset path nor server configuration file");
        }
        if (this.serverConfig.datasetPath != null && dapRegistry.size() != 1) {
            log.error("Expected only one dataset in the DataAccessPointRegistry");
        }
        String datasetPath = this.serverConfig.datasetPath;
        String datasetDescription = this.serverConfig.datasetDescription;
        String serverConfigFile = this.serverConfig.serverConfig;
        String staticFiles = this.serverConfig.contentDirectory;
        boolean verbose = this.serverConfig.verboseLogging;
        if (!super.isQuiet()) {
            FusekiInfo.logServerSetup((Logger)log, (boolean)verbose, (DataAccessPointRegistry)dapRegistry, (String)datasetPath, (String)datasetDescription, (String)serverConfigFile, (String)staticFiles);
        }
    }

    protected String getCommandName() {
        return "fuseki";
    }
}

