/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.fuseki.main.sys;

import java.util.Set;
import org.apache.jena.fuseki.main.FusekiServer;
import org.apache.jena.fuseki.main.sys.FusekiModules;
import org.apache.jena.fuseki.server.DataAccessPointRegistry;
import org.apache.jena.rdf.model.Model;

public class FusekiModuleStep {
    public static void prepare(FusekiServer.Builder serverBuilder, Set<String> datasetNames, Model configModel) {
        FusekiModules.forEachModule(module -> module.prepare(serverBuilder, datasetNames, configModel));
    }

    public static void configured(DataAccessPointRegistry dapRegistry, Model configModel) {
        FusekiModules.forEachModule(module -> module.configured(dapRegistry, configModel));
    }

    public static void server(FusekiServer server) {
        FusekiModules.forEachModule(module -> module.server(server));
    }

    public static void serverBeforeStarting(FusekiServer server) {
        FusekiModules.forEachModule(module -> module.serverBeforeStarting(server));
    }

    public static void serverAfterStarting(FusekiServer server) {
        FusekiModules.forEachModule(module -> module.serverAfterStarting(server));
    }

    public static void serverStopped(FusekiServer server) {
        FusekiModules.forEachModule(module -> module.serverStopped(server));
    }
}

