/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.rdfxml.xmlinput.impl;

import com.hp.hpl.jena.rdfxml.xmlinput.FatalParsingErrorException;
import com.hp.hpl.jena.rdfxml.xmlinput.SAX2RDF;
import com.hp.hpl.jena.rdfxml.xmlinput.impl.WrappedException;
import com.hp.hpl.jena.rdfxml.xmlinput.impl.XMLHandler;
import com.hp.hpl.jena.util.CharEncoding;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UTFDataFormatException;
import org.apache.xerces.parsers.SAXParser;
import org.apache.xerces.parsers.StandardParserConfiguration;
import org.apache.xerces.xni.Augmentations;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class RDFXMLParser
extends XMLHandler {
    private SAXParser saxParser;
    private String readerXMLEncoding = null;
    private String xmlEncoding = null;

    protected RDFXMLParser(SAXParser rdr) {
        this.saxParser = rdr;
        try {
            SAX2RDF.installHandlers(rdr, this);
        }
        catch (SAXException e2) {
            throw new RuntimeException("Supposedly impossible:", e2);
        }
    }

    public SAXParser getSAXParser() {
        return this.saxParser;
    }

    public static RDFXMLParser create() {
        StandardParserConfiguration c = new StandardParserConfiguration();
        SAXParserWithEncodingCheck msp = new SAXParserWithEncodingCheck(c);
        RDFXMLParser a = new RDFXMLParser(msp);
        msp.setRdfXmlParser(a);
        return a;
    }

    public void parse(InputSource input) throws IOException, SAXException {
        this.parse(input, input.getSystemId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void parse(InputSource input, String base) throws IOException, SAXException {
        this.initParse(base, "");
        SAX2RDF.installHandlers(this.saxParser, this);
        this.saxParser.reset();
        this.initEncodingChecks(input);
        try {
            this.saxParser.parse(input);
        }
        catch (UTFDataFormatException e2) {
            this.generalError(212, e2);
        }
        catch (IOException e3) {
            this.generalError(213, e3);
        }
        catch (WrappedException wrapped) {
            wrapped.throwMe();
        }
        catch (FatalParsingErrorException fatalParsingErrorException) {
        }
        finally {
            this.afterParse();
        }
    }

    private void initEncodingChecks(InputSource in) {
        Reader rdr = in.getCharacterStream();
        this.readerXMLEncoding = null;
        this.encodingProblems = false;
        if (rdr != null && rdr instanceof InputStreamReader) {
            String javaEnc = ((InputStreamReader)rdr).getEncoding();
            this.readerXMLEncoding = CharEncoding.create(javaEnc).name();
        }
    }

    protected void setEncoding(String original) throws SAXParseException {
        CharEncoding encodingInfo = CharEncoding.create(original);
        String e2 = encodingInfo.name();
        if (this.xmlEncoding == null) {
            if (e2.equals("UTF") && this.readerXMLEncoding != null && this.readerXMLEncoding.startsWith("UTF")) {
                this.xmlEncoding = this.readerXMLEncoding;
                return;
            }
            this.xmlEncoding = e2;
            if (this.readerXMLEncoding != null && !this.readerXMLEncoding.equalsIgnoreCase(e2)) {
                this.warning(null, 129, "Encoding on InputStreamReader or FileReader does not match that of XML document. Use FileInputStream. [" + this.readerXMLEncoding + " != " + e2 + "]");
                this.encodingProblems = true;
            }
            if (e2.equals("UTF")) {
                return;
            }
            if (!encodingInfo.isIANA()) {
                this.warning(null, encodingInfo.isInNIO() ? 133 : 132, encodingInfo.warningMessage());
            } else if (!original.equalsIgnoreCase(e2)) {
                this.warning(null, 134, "The encoding \"" + original + "\" is not the canonical name at IANA, suggest \"" + e2 + "\" would give more interoperability.");
            }
        }
    }

    protected static class SAXParserWithEncodingCheck
    extends SAXParser {
        private RDFXMLParser rdfXmlParser;

        protected SAXParserWithEncodingCheck(StandardParserConfiguration c) {
            super(c);
        }

        @Override
        public void xmlDecl(String version2, String encoding, String standalone, Augmentations augs) {
            try {
                this.getRdfXmlParser().setEncoding(encoding == null ? "UTF" : encoding);
            }
            catch (SAXParseException e2) {
                throw new WrappedException(e2);
            }
            super.xmlDecl(version2, encoding, standalone, augs);
        }

        public void setRdfXmlParser(RDFXMLParser rdfXmlParser) {
            this.rdfXmlParser = rdfXmlParser;
        }

        public RDFXMLParser getRdfXmlParser() {
            if (this.rdfXmlParser == null) {
                throw new IllegalStateException("setRdfXmlParser must be called as part of the initialization process");
            }
            return this.rdfXmlParser;
        }
    }
}

