/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.shared.wg;

import com.hp.hpl.jena.shared.JenaException;
import com.hp.hpl.jena.shared.wg.LazyInputStream;
import com.hp.hpl.jena.shared.wg.LazyURLInputStream;
import com.hp.hpl.jena.shared.wg.LazyZipEntryInputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.zip.ZipFile;
import org.apache.jena.iri.IRI;
import org.apache.jena.iri.IRIFactory;

public class TestInputStreamFactory {
    final IRIFactory iriFactory = IRIFactory.jenaImplementation();
    private final IRI base;
    private final IRI mapBase;
    private final ZipFile zip;
    private final String property;
    private String createMe = "error";

    public TestInputStreamFactory(IRI baseDir, IRI getBaseDir) {
        this.base = baseDir;
        this.mapBase = getBaseDir;
        this.zip = null;
        this.property = null;
    }

    public TestInputStreamFactory(IRI baseDir, ZipFile zip) {
        this.base = baseDir;
        this.mapBase = null;
        this.zip = zip;
        this.property = null;
    }

    public TestInputStreamFactory(IRI baseDir, String propDir) {
        this.createMe = "new TestInputStreamFactory(URI.create(\"" + baseDir.toString() + "\"),\"" + propDir + "\")";
        this.base = baseDir;
        this.mapBase = null;
        this.zip = null;
        this.property = propDir.endsWith("/") ? propDir : propDir + "/";
    }

    public IRI getBase() {
        return this.base;
    }

    public InputStream open(String str2) {
        return this.open(this.iriFactory.create(str2));
    }

    public InputStream fullyOpen(String str2) throws IOException {
        InputStream in = this.open(this.iriFactory.create(str2));
        if (in instanceof LazyInputStream && !((LazyInputStream)in).connect()) {
            return null;
        }
        return in;
    }

    public InputStream open(IRI uri) {
        return (InputStream)this.open(uri, true);
    }

    public boolean savable() {
        return this.mapBase != null && this.mapBase.getScheme().equalsIgnoreCase("file");
    }

    public OutputStream openOutput(String str2) {
        OutputStream foo = (OutputStream)this.open(this.iriFactory.create(str2), false);
        return foo;
    }

    public String getCreationJava() {
        return this.createMe;
    }

    private Object open(IRI uri, boolean in) {
        IRI relative;
        IRI iRI = relative = uri.isAbsolute() ? this.base.relativize(uri, 8) : uri;
        if (relative.isAbsolute()) {
            throw new IllegalArgumentException("This  TestInputStreamFactory only knows about '" + this.base + "'.");
        }
        String relPath = relative.toString();
        if (relPath.length() - relPath.lastIndexOf(46) > 5) {
            relPath = relPath + ".rdf";
            relative = this.iriFactory.create(relPath);
        }
        if (this.mapBase != null) {
            try {
                URL url = this.mapBase.create(relative).toURL();
                if (!in) {
                    if (url.getProtocol().equalsIgnoreCase("file")) {
                        return new FileOutputStream(url.getFile());
                    }
                    throw new IllegalArgumentException("Can only save to file: scheme");
                }
                return new LazyURLInputStream(url);
            }
            catch (MalformedURLException e2) {
                throw new JenaException(e2);
            }
            catch (IOException e3) {
                e3.printStackTrace();
                throw new JenaException(e3);
            }
        }
        if (!in) {
            throw new IllegalArgumentException("Can only save to URLs");
        }
        if (this.zip != null) {
            return new LazyZipEntryInputStream(this.zip, relPath);
        }
        return TestInputStreamFactory.getInputStream(this.property + relPath);
    }

    private static InputStream getInputStream(String prop) {
        ClassLoader loader = TestInputStreamFactory.class.getClassLoader();
        if (loader == null) {
            throw new SecurityException("Cannot access class loader");
        }
        InputStream in = loader.getResourceAsStream("testing/" + prop);
        if (in == null) {
            try {
                in = new FileInputStream("testing/" + prop);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (in == null) {
                throw new IllegalArgumentException("Resource: " + prop + " not found on class path.");
            }
        }
        return in;
    }

    public IRI getMapBase() {
        return this.mapBase;
    }
}

