/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.algebra.optimize;

import com.hp.hpl.jena.sparql.algebra.Op;
import com.hp.hpl.jena.sparql.algebra.OpVars;
import com.hp.hpl.jena.sparql.algebra.TransformCopy;
import com.hp.hpl.jena.sparql.algebra.op.Op2;
import com.hp.hpl.jena.sparql.algebra.op.OpAssign;
import com.hp.hpl.jena.sparql.algebra.op.OpBGP;
import com.hp.hpl.jena.sparql.algebra.op.OpBase;
import com.hp.hpl.jena.sparql.algebra.op.OpConditional;
import com.hp.hpl.jena.sparql.algebra.op.OpFilter;
import com.hp.hpl.jena.sparql.algebra.op.OpGraph;
import com.hp.hpl.jena.sparql.algebra.op.OpGroup;
import com.hp.hpl.jena.sparql.algebra.op.OpJoin;
import com.hp.hpl.jena.sparql.algebra.op.OpLeftJoin;
import com.hp.hpl.jena.sparql.algebra.op.OpModifier;
import com.hp.hpl.jena.sparql.algebra.op.OpN;
import com.hp.hpl.jena.sparql.algebra.op.OpProject;
import com.hp.hpl.jena.sparql.algebra.op.OpQuadPattern;
import com.hp.hpl.jena.sparql.algebra.op.OpSequence;
import com.hp.hpl.jena.sparql.algebra.op.OpTable;
import com.hp.hpl.jena.sparql.algebra.op.OpUnion;
import com.hp.hpl.jena.sparql.core.Substitute;
import com.hp.hpl.jena.sparql.core.Var;
import com.hp.hpl.jena.sparql.core.VarExprList;
import com.hp.hpl.jena.sparql.expr.E_Equals;
import com.hp.hpl.jena.sparql.expr.E_SameTerm;
import com.hp.hpl.jena.sparql.expr.Expr;
import com.hp.hpl.jena.sparql.expr.ExprFunction2;
import com.hp.hpl.jena.sparql.expr.ExprList;
import com.hp.hpl.jena.sparql.expr.ExprVar;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.jena.atlas.lib.CollectionUtils;
import org.apache.jena.atlas.lib.Pair;
import org.apache.jena.atlas.lib.Tuple;

public class TransformFilterImplicitJoin
extends TransformCopy {
    @Override
    public Op transform(OpFilter opFilter, Op subOp) {
        Op op = TransformFilterImplicitJoin.apply(opFilter.getExprs(), subOp);
        if (op == null) {
            return super.transform(opFilter, subOp);
        }
        return op;
    }

    private static Op apply(ExprList exprs, Op subOp) {
        Pair<List<Pair<Var, Var>>, ExprList> p = TransformFilterImplicitJoin.preprocessFilterImplicitJoin(subOp, exprs);
        if (p == null || p.getLeft().size() == 0) {
            return null;
        }
        List<Pair<Var, Var>> joins = p.getLeft();
        Collection<Var> varsMentioned = TransformFilterImplicitJoin.varsMentionedInImplictJoins(joins);
        ExprList remaining = p.getRight();
        if (varsMentioned.size() != joins.size() * 2) {
            return null;
        }
        Op op = subOp;
        if (TransformFilterImplicitJoin.testSpecialCaseUnused(subOp, joins, remaining)) {
            return OpTable.empty();
        }
        if (TransformFilterImplicitJoin.testSpecialCaseOptional(subOp, joins, remaining)) {
            List<Op> ops = TransformFilterImplicitJoin.extractOptionals(subOp);
            ops = TransformFilterImplicitJoin.processSpecialCaseOptional(ops, joins);
            op = TransformFilterImplicitJoin.rebuild((Op2)subOp, ops);
            op = OpFilter.filter(exprs, op);
            return op;
        }
        if (TransformFilterImplicitJoin.testSpecialCaseUnion(subOp, joins) && (op = TransformFilterImplicitJoin.processSpecialCaseUnion(subOp, joins)) instanceof OpTable) {
            return op;
        }
        if (!TransformFilterImplicitJoin.safeToTransform(joins, varsMentioned, op)) {
            return null;
        }
        for (Pair<Var, Var> implicitJoin : joins) {
            op = TransformFilterImplicitJoin.processFilterWorker(op, implicitJoin.getLeft(), implicitJoin.getRight());
        }
        if (remaining.size() > 0) {
            op = OpFilter.filter(remaining, op);
        }
        return op;
    }

    private static Pair<List<Pair<Var, Var>>, ExprList> preprocessFilterImplicitJoin(Op subOp, ExprList exprs) {
        ArrayList<Pair<Var, Var>> exprsJoins = new ArrayList<Pair<Var, Var>>();
        ExprList exprsOther = new ExprList();
        for (Expr e2 : exprs.getList()) {
            Pair<Var, Var> p = TransformFilterImplicitJoin.preprocess(subOp, e2);
            if (p != null) {
                exprsJoins.add(p);
                continue;
            }
            exprsOther.add(e2);
        }
        if (exprsJoins.size() == 0) {
            return null;
        }
        return Pair.create(exprsJoins, exprsOther);
    }

    private static Pair<Var, Var> preprocess(Op subOp, Expr e2) {
        Tuple<Set<Var>> varsByPosition;
        if (!(e2 instanceof E_Equals) && !(e2 instanceof E_SameTerm)) {
            return null;
        }
        ExprFunction2 eq = (ExprFunction2)e2;
        Expr left = eq.getArg1();
        Expr right = eq.getArg2();
        if (!left.isVariable() || !right.isVariable()) {
            return null;
        }
        if (left.equals(right)) {
            return null;
        }
        if (e2 instanceof E_Equals && !TransformFilterImplicitJoin.isSafeEquals(varsByPosition = OpVars.mentionedVarsByPosition(subOp), left.asVar(), right.asVar())) {
            return null;
        }
        return Pair.create(left.asVar(), right.asVar());
    }

    private static boolean isSafeEquals(Tuple<Set<Var>> varsByPosition, Var left, Var right) {
        if (varsByPosition.size() != 5) {
            return false;
        }
        HashSet safeVars = new HashSet();
        safeVars.addAll(varsByPosition.get(0));
        safeVars.addAll(varsByPosition.get(1));
        safeVars.addAll(varsByPosition.get(2));
        HashSet unsafeVars = new HashSet();
        unsafeVars.addAll(varsByPosition.get(3));
        unsafeVars.addAll(varsByPosition.get(4));
        boolean lhsSafe = true;
        boolean rhsSafe = true;
        if (unsafeVars.size() > 0) {
            if (unsafeVars.contains(left) && !safeVars.contains(left)) {
                lhsSafe = false;
            }
            if (unsafeVars.contains(right) && !safeVars.contains(right)) {
                rhsSafe = false;
            }
        }
        return lhsSafe || rhsSafe;
    }

    private static Collection<Var> varsMentionedInImplictJoins(List<Pair<Var, Var>> joins) {
        HashSet<Var> vars = new HashSet<Var>();
        for (Pair<Var, Var> p : joins) {
            vars.add(p.getLeft());
            vars.add(p.getRight());
        }
        return vars;
    }

    private static boolean safeToTransform(List<Pair<Var, Var>> joins, Collection<Var> varsEquality, Op op) {
        OpTable opTable;
        if (op instanceof OpBGP || op instanceof OpQuadPattern) {
            return true;
        }
        if (op instanceof OpFilter) {
            OpFilter opf = (OpFilter)op;
            return TransformFilterImplicitJoin.safeToTransform(joins, varsEquality, opf.getSubOp());
        }
        if (op instanceof OpSequence) {
            OpN opN = (OpN)op;
            for (Op subOp : opN.getElements()) {
                if (TransformFilterImplicitJoin.safeToTransform(joins, varsEquality, subOp)) continue;
                return false;
            }
            return true;
        }
        if (op instanceof OpJoin) {
            Op2 op2 = (Op2)op;
            return TransformFilterImplicitJoin.safeToTransform(joins, varsEquality, op2.getLeft()) && TransformFilterImplicitJoin.safeToTransform(joins, varsEquality, op2.getRight());
        }
        if (op instanceof OpUnion) {
            Set<Var> fixedVars = OpVars.fixedVars(op);
            for (Pair<Var, Var> pair : joins) {
                if (fixedVars.contains(pair.getLeft()) && !fixedVars.contains(pair.getRight())) {
                    return false;
                }
                if (fixedVars.contains(pair.getLeft()) || !fixedVars.contains(pair.getRight())) continue;
                return false;
            }
            return true;
        }
        if (op instanceof OpConditional || op instanceof OpLeftJoin) {
            Op2 opleftjoin = (Op2)op;
            if (!TransformFilterImplicitJoin.safeToTransform(joins, varsEquality, opleftjoin.getLeft()) || !TransformFilterImplicitJoin.safeToTransform(joins, varsEquality, opleftjoin.getRight())) {
                return false;
            }
            Op opLeft = opleftjoin.getLeft();
            Set<Var> varsLeft = OpVars.visibleVars(opLeft);
            return varsLeft.containsAll(varsEquality);
        }
        if (op instanceof OpGraph) {
            OpGraph opg = (OpGraph)op;
            return TransformFilterImplicitJoin.safeToTransform(joins, varsEquality, opg.getSubOp());
        }
        if (op instanceof OpModifier) {
            OpModifier opMod = (OpModifier)op;
            if (opMod instanceof OpProject) {
                OpProject opProject = (OpProject)op;
                for (Var v : opProject.getVars()) {
                    if (!varsEquality.contains(v)) continue;
                    return false;
                }
            }
            return TransformFilterImplicitJoin.safeToTransform(joins, varsEquality, opMod.getSubOp());
        }
        if (op instanceof OpGroup) {
            OpGroup opGroup = (OpGroup)op;
            VarExprList varExprList = opGroup.getGroupVars();
            return TransformFilterImplicitJoin.safeToTransform(varsEquality, varExprList) && TransformFilterImplicitJoin.safeToTransform(joins, varsEquality, opGroup.getSubOp());
        }
        return op instanceof OpTable && (opTable = (OpTable)op).isJoinIdentity();
    }

    private static boolean safeToTransform(Collection<Var> varsEquality, VarExprList varsExprList) {
        return CollectionUtils.disjoint(varsExprList.getVars(), varsEquality);
    }

    private static boolean testSpecialCaseUnused(Op op, List<Pair<Var, Var>> joins, ExprList remaining) {
        Set<Var> patternVars = OpVars.visibleVars(op);
        for (Pair<Var, Var> p : joins) {
            if (patternVars.contains(p.getLeft()) && patternVars.contains(p.getRight())) continue;
            return true;
        }
        return false;
    }

    private static boolean testSpecialCaseOptional(Op op, List<Pair<Var, Var>> joins, ExprList remaining) {
        while (op instanceof OpConditional || op instanceof OpLeftJoin) {
            Op2 opleftjoin2 = (Op2)op;
            op = opleftjoin2.getLeft();
        }
        return TransformFilterImplicitJoin.isTableUnit(op);
    }

    private static boolean testSpecialCaseUnion(Op op, List<Pair<Var, Var>> joins) {
        if (op instanceof OpUnion) {
            OpUnion union = (OpUnion)op;
            Set<Var> leftVars = OpVars.visibleVars(union.getLeft());
            Set<Var> rightVars = OpVars.visibleVars(union.getRight());
            for (Pair<Var, Var> p : joins) {
                if (!leftVars.contains(p.getLeft()) || !leftVars.contains(p.getRight())) {
                    return true;
                }
                if (rightVars.contains(p.getLeft()) && rightVars.contains(p.getRight())) continue;
                return true;
            }
        }
        return false;
    }

    private static List<Op> extractOptionals(Op op) {
        ArrayList<Op> chain = new ArrayList<Op>();
        while (op instanceof OpConditional || op instanceof OpLeftJoin) {
            Op2 opleftjoin2 = (Op2)op;
            chain.add(opleftjoin2.getRight());
            op = opleftjoin2.getLeft();
        }
        return chain;
    }

    private static List<Op> processSpecialCaseOptional(List<Op> ops, List<Pair<Var, Var>> joins) {
        ArrayList<Op> ops2 = new ArrayList<Op>();
        Collection<Var> vars = TransformFilterImplicitJoin.varsMentionedInImplictJoins(joins);
        Iterator<Op> i$ = ops.iterator();
        while (i$.hasNext()) {
            Op op;
            Op op2 = op = i$.next();
            if (TransformFilterImplicitJoin.safeToTransform(joins, vars, op)) {
                for (Pair<Var, Var> p : joins) {
                    op2 = TransformFilterImplicitJoin.processFilterWorker(op, p.getLeft(), p.getRight());
                }
            }
            ops2.add(op2);
        }
        return ops2;
    }

    private static Op rebuild(Op2 subOp, List<Op> ops) {
        OpBase chain = OpTable.unit();
        for (Op op : ops) {
            chain = subOp.copy(chain, op);
        }
        return chain;
    }

    private static boolean isTableUnit(Op op) {
        return op instanceof OpTable && ((OpTable)op).isJoinIdentity();
    }

    private static Op processSpecialCaseUnion(Op op, List<Pair<Var, Var>> joins) {
        if (op instanceof OpUnion) {
            OpUnion union = (OpUnion)op;
            Set<Var> leftVars = OpVars.visibleVars(union.getLeft());
            Set<Var> rightVars = OpVars.visibleVars(union.getRight());
            boolean leftEmpty = false;
            boolean rightEmpty = false;
            for (Pair<Var, Var> p : joins) {
                if (leftEmpty || !leftVars.contains(p.getLeft()) || !leftVars.contains(p.getRight())) {
                    leftEmpty = true;
                }
                if (!rightEmpty && rightVars.contains(p.getLeft()) && rightVars.contains(p.getRight())) continue;
                rightEmpty = true;
            }
            if (leftEmpty && rightEmpty) {
                return OpTable.empty();
            }
            if (leftEmpty) {
                return union.getRight();
            }
            if (rightEmpty) {
                return union.getLeft();
            }
        }
        return op;
    }

    private static Op processFilterWorker(Op op, Var find, Var replace) {
        return TransformFilterImplicitJoin.subst(op, find, replace);
    }

    private static Op subst(Op subOp, Var find, Var replace) {
        Op op = Substitute.substitute(subOp, find, replace);
        return OpAssign.assign(op, find, new ExprVar(replace));
    }
}

