/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.core;

import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.graph.impl.GraphBase;
import com.hp.hpl.jena.sparql.core.DatasetGraphCaching;
import com.hp.hpl.jena.sparql.core.Quad;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import com.hp.hpl.jena.util.iterator.WrappedIterator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class DatasetGraphSimpleMem
extends DatasetGraphCaching {
    private MiniSet<Triple> triples = new MiniSet();
    private MiniSet<Quad> quads = new MiniSet();

    @Override
    public Iterator<Quad> findInDftGraph(Node s, Node p, Node o) {
        ArrayList<Quad> results = new ArrayList<Quad>();
        for (Triple t : this.triples) {
            if (!this.matches(t, s, p, o)) continue;
            results.add(new Quad(Quad.defaultGraphIRI, t));
        }
        return results.iterator();
    }

    @Override
    public Iterator<Quad> findInSpecificNamedGraph(Node g, Node s, Node p, Node o) {
        ArrayList<Quad> results = new ArrayList<Quad>();
        for (Quad q : this.quads) {
            if (!this.matches(q, g, s, p, o)) continue;
            results.add(q);
        }
        return results.iterator();
    }

    @Override
    public Iterator<Quad> findInAnyNamedGraphs(Node s, Node p, Node o) {
        ArrayList<Quad> results = new ArrayList<Quad>();
        for (Quad q : this.quads) {
            if (!this.matches(q, Node.ANY, s, p, o)) continue;
            results.add(q);
        }
        return results.iterator();
    }

    public static Node nullAsAny(Node x) {
        return DatasetGraphSimpleMem.nullAsDft(x, Node.ANY);
    }

    public static Node nullAsDft(Node x, Node dft) {
        return x == null ? dft : x;
    }

    private boolean matches(Triple t, Node s, Node p, Node o) {
        s = DatasetGraphSimpleMem.nullAsAny(s);
        p = DatasetGraphSimpleMem.nullAsAny(p);
        o = DatasetGraphSimpleMem.nullAsAny(o);
        return t.matches(s, p, o);
    }

    private boolean matches(Quad q, Node g, Node s, Node p, Node o) {
        g = DatasetGraphSimpleMem.nullAsAny(g);
        s = DatasetGraphSimpleMem.nullAsAny(s);
        p = DatasetGraphSimpleMem.nullAsAny(p);
        o = DatasetGraphSimpleMem.nullAsAny(o);
        return q.matches(g, s, p, o);
    }

    @Override
    protected void addToDftGraph(Node s, Node p, Node o) {
        Triple t = new Triple(s, p, o);
        this.triples.add(t);
    }

    @Override
    protected void addToNamedGraph(Node g, Node s, Node p, Node o) {
        Quad q = new Quad(g, s, p, o);
        this.quads.add(q);
    }

    @Override
    protected void deleteFromDftGraph(Node s, Node p, Node o) {
        this.triples.remove(new Triple(s, p, o));
    }

    @Override
    protected void deleteFromNamedGraph(Node g, Node s, Node p, Node o) {
        this.quads.remove(new Quad(g, s, p, o));
    }

    @Override
    protected Graph _createDefaultGraph() {
        return new GraphDft();
    }

    @Override
    protected Graph _createNamedGraph(Node graphNode) {
        return new GraphNamed(graphNode);
    }

    @Override
    protected boolean _containsGraph(Node graphNode) {
        return this.graphNodes().contains(graphNode);
    }

    @Override
    public Iterator<Node> listGraphNodes() {
        return this.graphNodes().iterator();
    }

    private Set<Node> graphNodes() {
        HashSet<Node> x = new HashSet<Node>();
        for (Quad q : this.quads) {
            x.add(q.getGraph());
        }
        return x;
    }

    @Override
    protected void _close() {
    }

    class GraphNamed
    extends GraphBase {
        private final Node graphName;

        GraphNamed(Node gname) {
            this.graphName = gname;
        }

        @Override
        public void performAdd(Triple t) {
            Quad q = new Quad(this.graphName, t);
            DatasetGraphSimpleMem.this.quads.add(q);
        }

        @Override
        public void performDelete(Triple t) {
            Quad q = new Quad(this.graphName, t);
            DatasetGraphSimpleMem.this.quads.remove(q);
        }

        @Override
        protected ExtendedIterator<Triple> graphBaseFind(Triple m) {
            ArrayList<Triple> results = new ArrayList<Triple>();
            Iterator<Quad> iter = DatasetGraphSimpleMem.this.findNG(this.graphName, m.getMatchSubject(), m.getMatchPredicate(), m.getMatchObject());
            while (iter.hasNext()) {
                results.add(iter.next().asTriple());
            }
            return WrappedIterator.create(results.iterator());
        }
    }

    class GraphDft
    extends GraphBase {
        GraphDft() {
        }

        @Override
        public void performAdd(Triple t) {
            DatasetGraphSimpleMem.this.triples.add(t);
        }

        @Override
        public void performDelete(Triple t) {
            DatasetGraphSimpleMem.this.triples.remove(t);
        }

        @Override
        protected ExtendedIterator<Triple> graphBaseFind(Triple m) {
            ArrayList<Triple> results = new ArrayList<Triple>();
            for (Triple t : DatasetGraphSimpleMem.this.triples) {
                if (!t.matches(m.getMatchSubject(), m.getMatchPredicate(), m.getMatchObject())) continue;
                results.add(t);
            }
            return WrappedIterator.create(results.iterator());
        }
    }

    private static class MiniSet<T>
    implements Iterable<T> {
        final Collection<T> store;

        MiniSet(Collection<T> store) {
            this.store = store;
        }

        MiniSet() {
            this.store = new ArrayList<T>();
        }

        void add(T t) {
            if (!this.store.contains(t)) {
                this.store.add(t);
            }
        }

        void remove(T t) {
            this.store.remove(t);
        }

        @Override
        public Iterator<T> iterator() {
            return this.store.iterator();
        }

        boolean isEmpty() {
            return this.store.isEmpty();
        }

        int size() {
            return this.store.size();
        }
    }
}

