/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.engine.iterator;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.sparql.algebra.op.OpProject;
import com.hp.hpl.jena.sparql.core.Var;
import com.hp.hpl.jena.sparql.engine.ExecutionContext;
import com.hp.hpl.jena.sparql.engine.QueryIterator;
import com.hp.hpl.jena.sparql.engine.binding.Binding;
import com.hp.hpl.jena.sparql.engine.binding.BindingFactory;
import com.hp.hpl.jena.sparql.engine.binding.BindingMap;
import com.hp.hpl.jena.sparql.engine.binding.BindingUtils;
import com.hp.hpl.jena.sparql.engine.iterator.QueryIterConvert;
import com.hp.hpl.jena.sparql.engine.iterator.QueryIterRepeatApply;
import com.hp.hpl.jena.sparql.engine.iterator.QueryIterSingleton;
import com.hp.hpl.jena.sparql.engine.main.OpExecutor;
import java.util.Iterator;
import java.util.List;
import org.apache.jena.atlas.logging.Log;

public class QueryIterProjectMerge
extends QueryIterRepeatApply {
    private final OpProject opProject;
    private final OpExecutor engine;

    public QueryIterProjectMerge(OpProject opProject, QueryIterator input, OpExecutor engine, ExecutionContext execCxt) {
        super(input, execCxt);
        this.opProject = opProject;
        this.engine = engine;
    }

    @Override
    protected QueryIterator nextStage(Binding binding) {
        QueryIterator qIter = this.engine.executeOp(this.opProject.getSubOp(), QueryIterSingleton.create(binding, this.getExecContext()));
        qIter = new QueryIterConvert(qIter, new ProjectEnsureBindingConverter(binding, this.opProject.getVars()), this.getExecContext());
        return qIter;
    }

    static class ProjectEnsureBindingConverter
    implements QueryIterConvert.Converter {
        private final Binding outerBinding;
        private final List<Var> projectionVars;

        public ProjectEnsureBindingConverter(Binding outerBinding, List<Var> vars) {
            this.outerBinding = outerBinding;
            this.projectionVars = vars;
        }

        @Override
        public Binding convert(Binding bind) {
            return ProjectEnsureBindingConverter.ensure(this.projectionVars, this.outerBinding, bind);
        }

        private static Binding ensure(List<Var> vars, Binding outer, Binding inner) {
            Iterator<Var> vIter;
            BindingMap b2 = BindingFactory.create(outer);
            Iterator<Var> iterator = vIter = vars != null ? vars.iterator() : inner.vars();
            while (vIter.hasNext()) {
                Var v = vIter.next();
                Node n2 = inner.get(v);
                if (n2 == null) continue;
                if (!b2.contains(v)) {
                    b2.add(v, inner.get(v));
                    continue;
                }
                Node n1 = outer.get(v);
                if (n1.equals(n2)) continue;
                Log.warn(BindingUtils.class, "merge: Mismatch : " + n1 + " != " + n2);
            }
            return b2;
        }
    }
}

