/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.engine.optimizer;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.sparql.ARQException;
import com.hp.hpl.jena.sparql.core.Var;
import com.hp.hpl.jena.sparql.engine.optimizer.Pattern;
import com.hp.hpl.jena.sparql.engine.optimizer.reorder.PatternElements;
import com.hp.hpl.jena.sparql.engine.optimizer.reorder.PatternTriple;
import com.hp.hpl.jena.sparql.graph.NodeConst;
import com.hp.hpl.jena.sparql.sse.Item;
import com.hp.hpl.jena.sparql.sse.ItemList;
import com.hp.hpl.jena.sparql.sse.SSE;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.jena.atlas.io.IndentedWriter;
import org.apache.jena.atlas.logging.Log;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class StatsMatcher {
    private static Logger log = LoggerFactory.getLogger(StatsMatcher.class);
    public static final String STATS = "stats";
    public static final String META = "meta";
    public static final String COUNT = "count";
    public static final Item OTHER = Item.createSymbol("other");
    private static double NOMATCH = -1.0;
    protected List<Pattern> patterns = new ArrayList<Pattern>();
    protected Map<Item, List<Pattern>> mapPatterns = new HashMap<Item, List<Pattern>>();
    double DefaultMatch = NOMATCH;
    long count = -1L;
    public static final double weightSP = 2.0;
    public static final double weightPO = 10.0;
    public static final double weightTypeO = 1000.0;
    public static final double weightSP_small = 2.0;
    public static final double weightPO_small = 4.0;
    public static final double weightTypeO_small = 40.0;

    public StatsMatcher() {
    }

    public StatsMatcher(String filename) {
        Item stats = SSE.readFile(filename);
        if (stats.isNil()) {
            Log.warn(this, "Empty stats file: " + filename);
            return;
        }
        if (!stats.isTagged(STATS)) {
            throw new ARQException("Not a stats file: " + filename);
        }
        this.init(stats);
    }

    public StatsMatcher(Item stats) {
        this.init(stats);
    }

    private void init(Item stats) {
        if (!stats.isTagged(STATS)) {
            throw new ARQException("Not a tagged 'stats'");
        }
        ItemList list = stats.getList().cdr();
        if (list.car().isTagged(META)) {
            Item elt1 = list.car();
            list = list.cdr();
            Item x = Item.find(elt1.getList(), COUNT);
            if (x != null) {
                this.count = x.getList().get(1).asInteger();
            }
        }
        while (!list.isEmpty()) {
            Item elt = list.car();
            list = list.cdr();
            this.onePattern(elt);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void onePattern(Item elt) {
        Item pat = elt.getList().get(0);
        if (pat.isNode()) {
            Node n = pat.getNode();
            if (!n.isURI()) {
                log.warn("Not a preicate URI: " + pat.toString());
                return;
            }
            this.addAbbreviation(elt);
            return;
        }
        if (pat.isSymbol()) {
            if (pat.equals(OTHER)) {
                double d;
                this.DefaultMatch = d = elt.getList().get(1).getDouble();
                return;
            }
            if (pat.equals(PatternElements.BNODE) || pat.equals(PatternElements.LITERAL)) {
                log.warn("Not a match for a predicate URI: " + pat.toString());
                return;
            }
            if (!(pat.equals(PatternElements.TERM) || pat.equals(PatternElements.VAR) || pat.equals(PatternElements.ANY))) {
                log.warn("Not understood: " + pat);
                return;
            }
            this.addAbbreviation(elt);
            return;
        }
        if (pat.isList() && pat.getList().size() == 3) {
            Item w = elt.getList().get(1);
            Pattern pattern = new Pattern(((Number)w.getNode().getLiteralValue()).doubleValue(), this.intern(pat.getList().get(0)), this.intern(pat.getList().get(1)), this.intern(pat.getList().get(2)));
            this.addPattern(pattern);
            return;
        }
        log.warn("Unrecognized pattern: " + pat);
    }

    private void addAbbreviation(Item elt) {
        Item predicateTerm = elt.getList().get(0);
        double numProp = elt.getList().get(1).getDouble();
        if (this.count < 100L) {
            this.addPatternsSmall(predicateTerm, numProp);
        } else {
            this.addPatterns(predicateTerm, numProp);
        }
    }

    public void addPatterns(Node predicate, double numProp) {
        this.addPatterns(Item.createNode(predicate), numProp);
    }

    public void addPatternsSmall(Node predicate, double numProp) {
        this.addPatternsSmall(Item.createNode(predicate), numProp);
    }

    private void addPatterns(Item predicate, double numProp) {
        double wSP = 2.0;
        double wPO = 10.0;
        wPO = Math.min(numProp, wPO);
        wSP = Math.min(numProp, wSP);
        if (NodeConst.nodeRDFType.equals(predicate.getNode())) {
            wPO = 1000.0;
        }
        this.addPatterns(predicate, numProp, wSP, wPO);
    }

    private void addPatternsSmall(Item predicate, double numProp) {
        double wSP = 2.0;
        double wPO = 4.0;
        wPO = Math.min(numProp, wPO);
        wSP = Math.min(numProp, wSP);
        if (predicate.isNode() && NodeConst.nodeRDFType.equals(predicate.getNode())) {
            wPO = 40.0;
        }
        this.addPatterns(predicate, numProp, wSP, wPO);
    }

    private void addPatterns(Item predicate, double wP, double wSP, double wPO) {
        this.addPattern(new Pattern(wSP, PatternElements.TERM, predicate, PatternElements.ANY));
        this.addPattern(new Pattern(wPO, PatternElements.ANY, predicate, PatternElements.TERM));
        this.addPattern(new Pattern(wP, PatternElements.ANY, predicate, PatternElements.ANY));
    }

    public void addPattern(Pattern pattern) {
        StatsMatcher.check(pattern);
        this.patterns.add(pattern);
        List<Pattern> entry = this.mapPatterns.get(pattern.predItem);
        if (entry == null) {
            entry = new ArrayList<Pattern>();
            this.mapPatterns.put(pattern.predItem, entry);
        }
        entry.add(pattern);
    }

    private static void check(Pattern pattern) {
        StatsMatcher.check(pattern.subjItem);
        StatsMatcher.check(pattern.predItem);
        StatsMatcher.check(pattern.objItem);
    }

    private static void check(Item item) {
        if (Var.isVar(item.getNode())) {
            throw new ARQException("Explicit variable used in a pattern (use VAR): " + item.getNode());
        }
    }

    private Item intern(Item item) {
        if (item.sameSymbol(PatternElements.ANY.getSymbol())) {
            return PatternElements.ANY;
        }
        if (item.sameSymbol(PatternElements.VAR.getSymbol())) {
            return PatternElements.VAR;
        }
        if (item.sameSymbol(PatternElements.TERM.getSymbol())) {
            return PatternElements.TERM;
        }
        if (item.sameSymbol(PatternElements.URI.getSymbol())) {
            return PatternElements.URI;
        }
        if (item.sameSymbol(PatternElements.LITERAL.getSymbol())) {
            return PatternElements.LITERAL;
        }
        if (item.sameSymbol(PatternElements.BNODE.getSymbol())) {
            return PatternElements.BNODE;
        }
        return item;
    }

    public double match(Triple t) {
        return this.match(Item.createNode(t.getSubject()), Item.createNode(t.getPredicate()), Item.createNode(t.getObject()));
    }

    public double match(PatternTriple pTriple) {
        return this.match(pTriple.subject, pTriple.predicate, pTriple.object);
    }

    public double match(Item subj, Item pred, Item obj) {
        double m = this.matchWorker(subj, pred, obj);
        if (m == NOMATCH && pred.isNodeURI()) {
            m = this.DefaultMatch;
        }
        return m;
    }

    private double matchWorker(Item subj, Item pred, Item obj) {
        if (PatternElements.isSet(subj) && PatternElements.isSet(pred) && PatternElements.isSet(obj)) {
            return 1.0;
        }
        if (pred.isNodeURI()) {
            double w = NOMATCH;
            w = this.search(pred, subj, pred, obj, w);
            w = this.search(PatternElements.TERM, subj, pred, obj, w);
            w = this.search(PatternElements.ANY, subj, pred, obj, w);
            return w;
        }
        if (pred.isVar()) {
            double w = NOMATCH;
            w = this.search(PatternElements.VAR, subj, pred, obj, w);
            w = this.search(PatternElements.ANY, subj, pred, obj, w);
            return w;
        }
        if (pred.equals(PatternElements.TERM)) {
            double w = NOMATCH;
            w = this.search(PatternElements.TERM, subj, pred, obj, w);
            w = this.search(PatternElements.ANY, subj, pred, obj, w);
            return w;
        }
        if (pred.equals(PatternElements.ANY)) {
            throw new ARQException("Predicate is ANY");
        }
        throw new ARQException("Unidentified predicate: " + pred + " in (" + subj + " " + pred + " " + obj + ")");
    }

    private double search(Item key, Item subj, Item pred, Item obj, double oldMin) {
        List<Pattern> entry = this.mapPatterns.get(key);
        if (entry == null) {
            return oldMin;
        }
        double w = StatsMatcher.matchLinear(entry, subj, pred, obj);
        return StatsMatcher.minPos(w, oldMin);
    }

    private static double minPos(double x, double y) {
        if (x == NOMATCH) {
            return y;
        }
        if (y == NOMATCH) {
            return x;
        }
        return Math.min(x, y);
    }

    private static double matchLinear(List<Pattern> patterns, Item subj, Item pred, Item obj) {
        for (Pattern pattern : patterns) {
            Match match = new Match();
            if (!StatsMatcher.matchNode(subj, pattern.subjItem, match) || !StatsMatcher.matchNode(pred, pattern.predItem, match) || !StatsMatcher.matchNode(obj, pattern.objItem, match)) continue;
            return pattern.weight;
        }
        return NOMATCH;
    }

    private static boolean matchNode(Item node, Item item, Match details) {
        if (PatternElements.isAny(item)) {
            ++details.anyMatches;
            return true;
        }
        if (PatternElements.isAnyVar(item)) {
            ++details.varMatches;
            return true;
        }
        if (node.isSymbol()) {
            if (node.equals(PatternElements.TERM)) {
                if (item.equals(PatternElements.TERM)) {
                    ++details.termMatches;
                    return true;
                }
                return false;
            }
            throw new ARQException("StatsMatcher: unexpected slot type: " + node);
        }
        if (!node.isNode()) {
            return false;
        }
        Node n = node.getNode();
        if (n.isConcrete()) {
            if (item.isNode() && item.getNode().equals(n)) {
                ++details.exactMatches;
                return true;
            }
            if (PatternElements.isAnyTerm(item)) {
                ++details.termMatches;
                return true;
            }
            if (PatternElements.isAnyURI(item) && n.isURI()) {
                ++details.termMatches;
                return true;
            }
            if (PatternElements.isAnyLiteral(item) && n.isLiteral()) {
                ++details.termMatches;
                return true;
            }
            if (PatternElements.isAnyBNode(item) && n.isBlank()) {
                ++details.termMatches;
                return true;
            }
        }
        return false;
    }

    public String toString() {
        String $ = "";
        for (Pattern p : this.patterns) {
            $ = $ + p + "\n";
        }
        return $;
    }

    public void printSSE(OutputStream ps) {
        IndentedWriter out = new IndentedWriter(ps);
        out.println("(stats");
        out.incIndent();
        for (Pattern p : this.patterns) {
            p.output(out);
            out.println();
        }
        out.decIndent();
        out.println(")");
        out.flush();
    }

    static /* synthetic */ double access$000() {
        return NOMATCH;
    }

    private static class Match {
        double weight = StatsMatcher.access$000();
        int exactMatches = 0;
        int termMatches = 0;
        int varMatches = 0;
        int anyMatches = 0;

        private Match() {
        }
    }
}

