/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.pfunction.library;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.NodeFactory;
import com.hp.hpl.jena.sparql.core.Var;
import com.hp.hpl.jena.sparql.engine.ExecutionContext;
import com.hp.hpl.jena.sparql.engine.QueryIterator;
import com.hp.hpl.jena.sparql.engine.binding.Binding;
import com.hp.hpl.jena.sparql.engine.binding.BindingFactory;
import com.hp.hpl.jena.sparql.engine.iterator.QueryIterPlainWrapper;
import com.hp.hpl.jena.sparql.expr.ExprEvalException;
import com.hp.hpl.jena.sparql.pfunction.PFuncSimpleAndList;
import com.hp.hpl.jena.sparql.pfunction.PropFuncArg;
import java.util.Arrays;
import java.util.Iterator;
import org.apache.jena.atlas.iterator.Iter;
import org.apache.jena.atlas.iterator.Transform;
import org.apache.jena.atlas.lib.StrUtils;

public class strSplit
extends PFuncSimpleAndList {
    @Override
    public QueryIterator execEvaluated(final Binding binding, Node subject, Node predicate, PropFuncArg object, ExecutionContext execCxt) {
        if (!Var.isVar(subject)) {
            throw new ExprEvalException("Subject is not a variable (" + subject + ")");
        }
        if (object.getArgListSize() != 2) {
            throw new ExprEvalException("Object list must contain exactly two arguments, the string to split and a regular expression");
        }
        String s = object.getArg(0).getLiteralLexicalForm();
        String regex = object.getArg(1).getLiteralLexicalForm();
        final Var subjectVar = Var.alloc(subject);
        String[] tokens2 = StrUtils.split(s, regex);
        Iterator<Binding> it = Iter.map(Arrays.asList(tokens2).iterator(), new Transform<String, Binding>(){

            @Override
            public Binding convert(String item) {
                return BindingFactory.binding(binding, subjectVar, NodeFactory.createLiteral(item));
            }
        });
        return new QueryIterPlainWrapper(it, execCxt);
    }
}

