/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.util;

import com.hp.hpl.jena.datatypes.BaseDatatype;
import com.hp.hpl.jena.datatypes.DatatypeFormatException;
import com.hp.hpl.jena.datatypes.TypeMapper;
import com.hp.hpl.jena.sparql.util.RomanNumeral;

public class RomanNumeralDatatype
extends BaseDatatype {
    private static boolean firstClassDatatype = false;
    private static RomanNumeralDatatype datatype = new RomanNumeralDatatype();
    private static final String URI = "http://rome.example.org/Numeral";

    public static void enableAsFirstClassDatatype() {
        if (!firstClassDatatype) {
            TypeMapper.getInstance().registerDatatype(RomanNumeralDatatype.get());
        }
    }

    public static RomanNumeralDatatype get() {
        return datatype;
    }

    private RomanNumeralDatatype() {
        super(URI);
    }

    @Override
    public Class<?> getJavaClass() {
        return RomanNumeral.class;
    }

    @Override
    public String unparse(Object value) {
        return value.toString();
    }

    @Override
    public Object parse(String lexicalForm) throws DatatypeFormatException {
        try {
            return RomanNumeral.r2i(lexicalForm);
        }
        catch (NumberFormatException ex) {
            throw new DatatypeFormatException(lexicalForm, this, ex.getMessage());
        }
    }

    @Override
    public String toString() {
        return "Roman Numeral";
    }
}

