/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.tdb.assembler;

import com.hp.hpl.jena.assembler.Assembler;
import com.hp.hpl.jena.assembler.Mode;
import com.hp.hpl.jena.assembler.assemblers.AssemblerBase;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.sparql.util.graph.GraphUtils;
import com.hp.hpl.jena.tdb.TDBException;
import com.hp.hpl.jena.tdb.assembler.VocabTDB;
import com.hp.hpl.jena.tdb.base.file.FileSet;
import com.hp.hpl.jena.tdb.base.file.Location;
import com.hp.hpl.jena.tdb.base.record.RecordFactory;
import com.hp.hpl.jena.tdb.index.IndexFactory;
import com.hp.hpl.jena.tdb.index.RangeIndex;
import com.hp.hpl.jena.tdb.setup.StoreParams;
import com.hp.hpl.jena.tdb.store.tupletable.TupleIndex;
import com.hp.hpl.jena.tdb.store.tupletable.TupleIndexRecord;
import com.hp.hpl.jena.tdb.sys.SystemTDB;
import java.util.Locale;
import org.apache.jena.atlas.lib.ColumnMap;

public class IndexAssembler
extends AssemblerBase {
    private Location location = null;

    private IndexAssembler() {
        this.location = null;
    }

    private IndexAssembler(Location location) {
        this.location = location;
    }

    @Override
    public TupleIndex open(Assembler a, Resource root, Mode mode) {
        GraphUtils.exactlyOneProperty(root, VocabTDB.pDescription);
        String desc = GraphUtils.getAsStringValue(root, VocabTDB.pDescription).toUpperCase(Locale.ENGLISH);
        GraphUtils.exactlyOneProperty(root, VocabTDB.pFile);
        String filename = GraphUtils.getAsStringValue(root, VocabTDB.pFile);
        if (this.location != null) {
            filename = this.location.absolute(filename);
        }
        String primary = null;
        RecordFactory rf = null;
        switch (desc.length()) {
            case 3: {
                primary = "SPO";
                rf = SystemTDB.indexRecordTripleFactory;
                break;
            }
            case 4: {
                primary = "GSPO";
                rf = SystemTDB.indexRecordQuadFactory;
                break;
            }
            default: {
                throw new TDBException("Bad length for index description: " + desc);
            }
        }
        FileSet fileset = null;
        StoreParams idxParams = StoreParams.getDftStoreParams();
        RangeIndex rIndex = IndexFactory.buildRangeIndex(fileset, rf, idxParams);
        return new TupleIndexRecord(desc.length(), new ColumnMap(primary, desc), desc, rf, rIndex);
    }
}

