/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.tdb.solver;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.sparql.core.Var;
import com.hp.hpl.jena.sparql.engine.ExecutionContext;
import com.hp.hpl.jena.tdb.solver.BindingNodeId;
import com.hp.hpl.jena.tdb.store.NodeId;
import com.hp.hpl.jena.tdb.store.nodetable.NodeTable;
import com.hp.hpl.jena.tdb.store.nodetupletable.NodeTupleTable;
import java.util.Iterator;
import java.util.List;
import org.apache.jena.atlas.iterator.Action;
import org.apache.jena.atlas.iterator.Filter;
import org.apache.jena.atlas.iterator.Iter;
import org.apache.jena.atlas.iterator.NullIterator;
import org.apache.jena.atlas.iterator.RepeatApplyIterator;
import org.apache.jena.atlas.iterator.Transform;
import org.apache.jena.atlas.lib.Tuple;

public class StageMatchTuple
extends RepeatApplyIterator<BindingNodeId> {
    private final NodeTupleTable nodeTupleTable;
    private final Tuple<Node> patternTuple;
    private final ExecutionContext execCxt;
    private boolean anyGraphs;
    private Filter<Tuple<NodeId>> filter;
    private static Transform<Tuple<NodeId>, Tuple<NodeId>> projectToTriples = new Transform<Tuple<NodeId>, Tuple<NodeId>>(){

        @Override
        public Tuple<NodeId> convert(Tuple<NodeId> item) {
            Tuple<NodeId> t2 = Tuple.createTuple(NodeId.NodeIdAny, item.get(1), item.get(2), item.get(3));
            return t2;
        }
    };
    private static Action<Tuple<NodeId>> quadsToAnyTriples = new Action<Tuple<NodeId>>(){

        @Override
        public void apply(Tuple<NodeId> item) {
            item.tuple()[0] = NodeId.NodeIdAny;
        }
    };

    public StageMatchTuple(NodeTupleTable nodeTupleTable, Iterator<BindingNodeId> input, Tuple<Node> tuple, boolean anyGraphs, Filter<Tuple<NodeId>> filter, ExecutionContext execCxt) {
        super(input);
        this.filter = filter;
        this.nodeTupleTable = nodeTupleTable;
        this.patternTuple = tuple;
        this.execCxt = execCxt;
        this.anyGraphs = anyGraphs;
    }

    public static void prepare(NodeTable nodeTable, Tuple<Node> patternTuple, BindingNodeId input, NodeId[] ids, Var[] var) {
        for (int i = 0; i < patternTuple.size(); ++i) {
            Node n = patternTuple.get(i);
            NodeId nId = StageMatchTuple.idFor(nodeTable, input, n);
            if (NodeId.isDoesNotExist(nId)) {
                new NullIterator();
            }
            ids[i] = nId;
            if (nId != null) continue;
            var[i] = StageMatchTuple.asVar(n);
        }
    }

    @Override
    protected Iterator<BindingNodeId> makeNextStage(final BindingNodeId input) {
        NodeId[] ids = new NodeId[this.patternTuple.size()];
        final Var[] var = new Var[this.patternTuple.size()];
        StageMatchTuple.prepare(this.nodeTupleTable.getNodeTable(), this.patternTuple, input, ids, var);
        Iterator<Tuple<NodeId>> iterMatches = this.nodeTupleTable.find(Tuple.create(ids));
        if (this.filter != null) {
            iterMatches = Iter.filter(iterMatches, this.filter);
        }
        if (this.anyGraphs) {
            iterMatches = Iter.operate(iterMatches, quadsToAnyTriples);
            iterMatches = Iter.distinctAdjacent(iterMatches);
        }
        Transform<Tuple<NodeId>, BindingNodeId> binder = new Transform<Tuple<NodeId>, BindingNodeId>(){

            @Override
            public BindingNodeId convert(Tuple<NodeId> tuple) {
                BindingNodeId output = new BindingNodeId(input);
                for (int i = 0; i < var.length; ++i) {
                    Var v = var[i];
                    if (v == null) continue;
                    NodeId id = tuple.get(i);
                    if (StageMatchTuple.reject(output, v, id)) {
                        return null;
                    }
                    output.put(v, id);
                }
                return output;
            }
        };
        return Iter.iter(iterMatches).map(binder).removeNulls();
    }

    private static Iterator<Tuple<NodeId>> print(Iterator<Tuple<NodeId>> iter) {
        if (!iter.hasNext()) {
            System.err.println("<empty>");
        } else {
            List<Tuple<NodeId>> r = Iter.toList(iter);
            String str2 = Iter.asString(r, "\n");
            System.err.println(str2);
            iter = Iter.iter(r);
        }
        return iter;
    }

    private static boolean reject(BindingNodeId output, Var var, NodeId value) {
        if (!output.containsKey(var)) {
            return false;
        }
        return !((NodeId)output.get(var)).equals(value);
    }

    private static Var asVar(Node node) {
        if (Var.isVar(node)) {
            return Var.alloc(node);
        }
        return null;
    }

    private static NodeId idFor(NodeTable nodeTable, BindingNodeId input, Node node) {
        if (Var.isVar(node)) {
            NodeId n = (NodeId)input.get(Var.alloc(node));
            return n;
        }
        return nodeTable.getNodeIdForNode(node);
    }
}

