/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.tdb.store.bulkloader;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.shared.PrefixMapping;
import com.hp.hpl.jena.sparql.core.Quad;
import com.hp.hpl.jena.sparql.util.Utils;
import com.hp.hpl.jena.tdb.TDB;
import com.hp.hpl.jena.tdb.TDBException;
import com.hp.hpl.jena.tdb.solver.stats.Stats;
import com.hp.hpl.jena.tdb.solver.stats.StatsCollector;
import com.hp.hpl.jena.tdb.store.DatasetGraphTDB;
import com.hp.hpl.jena.tdb.store.bulkloader.BulkStreamRDF;
import com.hp.hpl.jena.tdb.store.bulkloader.LoadMonitor;
import com.hp.hpl.jena.tdb.store.bulkloader.LoaderNodeTupleTable;
import com.hp.hpl.jena.tdb.store.nodetupletable.NodeTupleTable;
import com.hp.hpl.jena.tdb.store.nodetupletable.NodeTupleTableView;
import java.io.InputStream;
import java.util.List;
import org.apache.jena.atlas.event.EventType;
import org.apache.jena.riot.Lang;
import org.apache.jena.riot.RDFDataMgr;
import org.apache.jena.riot.RDFLanguages;
import org.apache.jena.riot.system.StreamRDF;
import org.slf4j.Logger;

public class BulkLoader {
    public static int DataTickPoint = 50000;
    public static long IndexTickPoint = 100000L;
    public static int superTick = 10;
    private static String baseName = "http://openjena.org/TDB/bulkload/event#";
    public static EventType evStartBulkload = new EventType(baseName + "start-bulkload");
    public static EventType evFinishBulkload = new EventType(baseName + "finish-bulkload");
    public static EventType evStartDataBulkload = new EventType(baseName + "start-bulkload-data");
    public static EventType evFinishDataBulkload = new EventType(baseName + "finish-bulkload-data");
    public static EventType evStartIndexBulkload = new EventType(baseName + "start-bulkload-index");
    public static EventType evFinishIndexBulkload = new EventType(baseName + "finish-bulkload-index");
    private static Logger loadLogger = TDB.logLoader;

    public static void loadDefaultGraph(DatasetGraphTDB dsg, List<String> urls, boolean showProgress) {
        BulkStreamRDF dest = BulkLoader.destinationDefaultGraph(dsg, showProgress);
        BulkLoader.loadTriples$(dest, urls);
    }

    public static void loadDefaultGraph(DatasetGraphTDB dsg, InputStream input, boolean showProgress) {
        BulkStreamRDF dest = BulkLoader.destinationDefaultGraph(dsg, showProgress);
        BulkLoader.loadTriples$(dest, input);
    }

    private static BulkStreamRDF destinationDefaultGraph(DatasetGraphTDB dsg, boolean showProgress) {
        return BulkLoader.destinationGraph(dsg, null, showProgress);
    }

    public static void loadNamedGraph(DatasetGraphTDB dsg, Node graphNode, List<String> urls, boolean showProgress) {
        BulkStreamRDF dest = BulkLoader.destinationNamedGraph(dsg, graphNode, showProgress);
        BulkLoader.loadTriples$(dest, urls);
    }

    public static void loadNamedGraph(DatasetGraphTDB dsg, Node graphNode, InputStream input, boolean showProgress) {
        BulkStreamRDF dest = BulkLoader.destinationNamedGraph(dsg, graphNode, showProgress);
        BulkLoader.loadTriples$(dest, input);
    }

    public static void loadDataset(DatasetGraphTDB dsg, List<String> urls, boolean showProgress) {
        BulkStreamRDF dest = BulkLoader.destinationDataset(dsg, showProgress);
        BulkLoader.loadQuads$(dest, urls);
    }

    public static void loadDataset(DatasetGraphTDB dsg, InputStream input, boolean showProgress) {
        BulkStreamRDF dest = BulkLoader.destinationDataset(dsg, showProgress);
        BulkLoader.loadQuads$(dest, input);
    }

    private static void loadTriples$(BulkStreamRDF dest, List<String> urls) {
        dest.startBulk();
        for (String url : urls) {
            loadLogger.info("Load: " + url + " -- " + Utils.nowAsString());
            Lang lang = RDFLanguages.filenameToLang(url, Lang.NTRIPLES);
            RDFDataMgr.parse((StreamRDF)dest, url, lang);
        }
        dest.finishBulk();
    }

    private static void loadTriples$(BulkStreamRDF dest, InputStream input) {
        loadLogger.info("Load: from input stream -- " + Utils.nowAsString());
        dest.startBulk();
        RDFDataMgr.parse((StreamRDF)dest, input, Lang.NTRIPLES);
        dest.finishBulk();
    }

    private static void loadQuads$(BulkStreamRDF dest, List<String> urls) {
        dest.startBulk();
        for (String url : urls) {
            loadLogger.info("Load: " + url + " -- " + Utils.nowAsString());
            Lang lang = RDFLanguages.filenameToLang(url, Lang.NQUADS);
            RDFDataMgr.parse((StreamRDF)dest, url, lang);
        }
        dest.finishBulk();
    }

    private static void loadQuads$(BulkStreamRDF dest, InputStream input) {
        loadLogger.info("Load: from input stream -- " + Utils.nowAsString());
        dest.startBulk();
        RDFDataMgr.parse((StreamRDF)dest, input, RDFLanguages.NQUADS);
        dest.finishBulk();
    }

    private static BulkStreamRDF destinationNamedGraph(DatasetGraphTDB dsg, Node graphName, boolean showProgress) {
        if (graphName == null) {
            return BulkLoader.destinationDefaultGraph(dsg, showProgress);
        }
        return BulkLoader.destinationGraph(dsg, graphName, showProgress);
    }

    public static LoadMonitor createLoadMonitor(DatasetGraphTDB dsg, String itemName, boolean showProgress) {
        if (showProgress) {
            return new LoadMonitor(dsg, loadLogger, itemName, DataTickPoint, IndexTickPoint);
        }
        return new LoadMonitor(dsg, null, itemName, DataTickPoint, IndexTickPoint);
    }

    private static BulkStreamRDF destinationDataset(DatasetGraphTDB dsg, boolean showProgress) {
        return new DestinationDSG(dsg, showProgress);
    }

    private static BulkStreamRDF destinationGraph(DatasetGraphTDB dsg, Node graphNode, boolean showProgress) {
        return new DestinationGraph(dsg, graphNode, showProgress);
    }

    static void forceSync(DatasetGraphTDB dsg) {
        dsg.getTripleTable().getNodeTupleTable().getNodeTable().sync();
        dsg.getQuadTable().getNodeTupleTable().getNodeTable().sync();
        dsg.getQuadTable().getNodeTupleTable().getNodeTable().sync();
        dsg.getPrefixes().getNodeTupleTable().getNodeTable().sync();
        dsg.sync();
    }

    private static final class DestinationGraph
    implements BulkStreamRDF {
        private final DatasetGraphTDB dsg;
        private final Node graphName;
        private final LoadMonitor monitor;
        private final LoaderNodeTupleTable loaderTriples;
        private final boolean startedEmpty;
        private long count = 0L;
        private StatsCollector stats;

        DestinationGraph(DatasetGraphTDB dsg, Node graphNode, boolean showProgress) {
            NodeTupleTable nodeTupleTable;
            this.dsg = dsg;
            this.graphName = graphNode;
            if (graphNode == null || Quad.isDefaultGraph(graphNode)) {
                nodeTupleTable = dsg.getTripleTable().getNodeTupleTable();
            } else {
                NodeTupleTable ntt = dsg.getQuadTable().getNodeTupleTable();
                nodeTupleTable = new NodeTupleTableView(ntt, this.graphName);
            }
            this.startedEmpty = dsg.isEmpty();
            this.monitor = BulkLoader.createLoadMonitor(dsg, "triples", showProgress);
            this.loaderTriples = new LoaderNodeTupleTable(nodeTupleTable, "triples", this.monitor);
        }

        @Override
        public final void startBulk() {
            this.loaderTriples.loadStart();
            this.loaderTriples.loadDataStart();
            this.stats = new StatsCollector();
        }

        @Override
        public final void triple(Triple triple) {
            Node s = triple.getSubject();
            Node p = triple.getPredicate();
            Node o = triple.getObject();
            this.loaderTriples.load(s, p, o);
            this.stats.record(null, s, p, o);
            ++this.count;
        }

        @Override
        public final void finishBulk() {
            this.loaderTriples.loadDataFinish();
            this.loaderTriples.loadIndexStart();
            this.loaderTriples.loadIndexFinish();
            this.loaderTriples.loadFinish();
            if (!this.dsg.getLocation().isMem() && this.startedEmpty) {
                String filename = this.dsg.getLocation().getPath("stats.opt");
                Stats.write(filename, this.stats.results());
            }
            BulkLoader.forceSync(this.dsg);
        }

        @Override
        public void start() {
        }

        @Override
        public void quad(Quad quad) {
            throw new TDBException("Quad encountered while loading a single graph");
        }

        @Override
        public void base(String base) {
        }

        @Override
        public void prefix(String prefix, String iri2) {
            if (this.graphName != null && this.graphName.isBlank()) {
                loadLogger.warn("Prefixes for blank node graphs not stored");
                return;
            }
            PrefixMapping pmap = this.graphName == null ? this.dsg.getPrefixes().getPrefixMapping() : this.dsg.getPrefixes().getPrefixMapping(this.graphName.getURI());
            pmap.setNsPrefix(prefix, iri2);
        }

        @Override
        public void finish() {
        }
    }

    private static final class DestinationDSG
    implements BulkStreamRDF {
        private final DatasetGraphTDB dsg;
        private final boolean startedEmpty;
        private final LoadMonitor monitor1;
        private final LoadMonitor monitor2;
        private final LoaderNodeTupleTable loaderTriples;
        private final LoaderNodeTupleTable loaderQuads;
        private final boolean showProgress;
        private long count = 0L;
        private StatsCollector stats;

        DestinationDSG(DatasetGraphTDB dsg, boolean showProgress) {
            this.dsg = dsg;
            this.startedEmpty = dsg.isEmpty();
            this.monitor1 = BulkLoader.createLoadMonitor(dsg, "triples", showProgress);
            this.monitor2 = BulkLoader.createLoadMonitor(dsg, "quads", showProgress);
            this.loaderTriples = new LoaderNodeTupleTable(dsg.getTripleTable().getNodeTupleTable(), "triples", this.monitor1);
            this.loaderQuads = new LoaderNodeTupleTable(dsg.getQuadTable().getNodeTupleTable(), "quads", this.monitor2);
            this.showProgress = showProgress;
        }

        @Override
        public final void startBulk() {
            this.loaderTriples.loadStart();
            this.loaderQuads.loadStart();
            this.loaderTriples.loadDataStart();
            this.loaderQuads.loadDataStart();
            this.stats = new StatsCollector();
        }

        @Override
        public void triple(Triple triple) {
            Node s = triple.getSubject();
            Node p = triple.getPredicate();
            Node o = triple.getObject();
            this.process(Quad.tripleInQuad, s, p, o);
        }

        @Override
        public void quad(Quad quad) {
            Node s = quad.getSubject();
            Node p = quad.getPredicate();
            Node o = quad.getObject();
            Node g = null;
            if (!quad.isTriple() && !quad.isDefaultGraph()) {
                g = quad.getGraph();
            }
            this.process(g, s, p, o);
        }

        private void process(Node g, Node s, Node p, Node o) {
            if (g == null) {
                this.loaderTriples.load(s, p, o);
            } else {
                this.loaderQuads.load(g, s, p, o);
            }
            ++this.count;
            this.stats.record(g, s, p, o);
        }

        @Override
        public void finishBulk() {
            this.loaderTriples.loadDataFinish();
            this.loaderQuads.loadDataFinish();
            this.loaderTriples.loadIndexStart();
            this.loaderQuads.loadIndexStart();
            this.loaderTriples.loadIndexFinish();
            this.loaderQuads.loadIndexFinish();
            this.loaderTriples.loadFinish();
            this.loaderQuads.loadFinish();
            if (!this.dsg.getLocation().isMem() && this.startedEmpty) {
                String filename = this.dsg.getLocation().getPath("stats.opt");
                Stats.write(filename, this.stats.results());
            }
            BulkLoader.forceSync(this.dsg);
        }

        @Override
        public void start() {
        }

        @Override
        public void base(String base) {
        }

        @Override
        public void prefix(String prefix, String iri2) {
            this.dsg.getPrefixes().getPrefixMapping().setNsPrefix(prefix, iri2);
        }

        @Override
        public void finish() {
        }
    }
}

