/*
 * Decompiled with CFR 0.152.
 */
package com.spatial4j.core.context;

import com.spatial4j.core.context.SpatialContext;
import com.spatial4j.core.distance.CartesianDistCalc;
import com.spatial4j.core.distance.DistanceCalculator;
import com.spatial4j.core.distance.GeodesicSphereDistCalc;
import com.spatial4j.core.io.BinaryCodec;
import com.spatial4j.core.io.WktShapeParser;
import com.spatial4j.core.shape.Rectangle;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.Map;

public class SpatialContextFactory {
    protected Map<String, String> args;
    protected ClassLoader classLoader;
    public boolean geo = true;
    public DistanceCalculator distCalc;
    public Rectangle worldBounds;
    public boolean normWrapLongitude = false;
    public Class<? extends WktShapeParser> wktShapeParserClass = WktShapeParser.class;
    public Class<? extends BinaryCodec> binaryCodecClass = BinaryCodec.class;

    public static SpatialContext makeSpatialContext(Map<String, String> args, ClassLoader classLoader) {
        SpatialContextFactory instance;
        String cname;
        if (classLoader == null) {
            classLoader = SpatialContextFactory.class.getClassLoader();
        }
        if ((cname = args.get("spatialContextFactory")) == null) {
            cname = System.getProperty("SpatialContextFactory");
        }
        if (cname == null) {
            instance = new SpatialContextFactory();
        } else {
            try {
                Class<?> c = classLoader.loadClass(cname);
                instance = (SpatialContextFactory)c.newInstance();
            }
            catch (Exception e2) {
                throw new RuntimeException(e2);
            }
        }
        instance.init(args, classLoader);
        return instance.newSpatialContext();
    }

    protected void init(Map<String, String> args, ClassLoader classLoader) {
        this.args = args;
        this.classLoader = classLoader;
        this.initField("geo");
        this.initCalculator();
        this.initWorldBounds();
        this.initField("normWrapLongitude");
        this.initField("wktShapeParserClass");
        this.initField("binaryCodecClass");
    }

    protected void initField(String name) {
        Field field;
        try {
            field = this.getClass().getField(name);
        }
        catch (NoSuchFieldException e2) {
            throw new Error(e2);
        }
        String str2 = this.args.get(name);
        if (str2 != null) {
            try {
                Object o;
                if (field.getType() == Boolean.TYPE) {
                    o = Boolean.valueOf(str2);
                } else if (field.getType() == Class.class) {
                    try {
                        o = this.classLoader.loadClass(str2);
                    }
                    catch (ClassNotFoundException e3) {
                        throw new RuntimeException(e3);
                    }
                } else if (field.getType().isEnum()) {
                    o = Enum.valueOf(field.getType().asSubclass(Enum.class), str2);
                } else {
                    throw new Error("unsupported field type: " + field.getType());
                }
                field.set(this, o);
            }
            catch (IllegalAccessException e4) {
                throw new Error(e4);
            }
            catch (Exception e5) {
                throw new RuntimeException("Invalid value '" + str2 + "' on field " + name + " of type " + field.getType(), e5);
            }
        }
    }

    protected void initCalculator() {
        String calcStr = this.args.get("distCalculator");
        if (calcStr == null) {
            return;
        }
        if (calcStr.equalsIgnoreCase("haversine")) {
            this.distCalc = new GeodesicSphereDistCalc.Haversine();
        } else if (calcStr.equalsIgnoreCase("lawOfCosines")) {
            this.distCalc = new GeodesicSphereDistCalc.LawOfCosines();
        } else if (calcStr.equalsIgnoreCase("vincentySphere")) {
            this.distCalc = new GeodesicSphereDistCalc.Vincenty();
        } else if (calcStr.equalsIgnoreCase("cartesian")) {
            this.distCalc = new CartesianDistCalc();
        } else if (calcStr.equalsIgnoreCase("cartesian^2")) {
            this.distCalc = new CartesianDistCalc(true);
        } else {
            throw new RuntimeException("Unknown calculator: " + calcStr);
        }
    }

    protected void initWorldBounds() {
        String worldBoundsStr = this.args.get("worldBounds");
        if (worldBoundsStr == null) {
            return;
        }
        SpatialContext simpleCtx = new SpatialContext(this);
        this.worldBounds = (Rectangle)simpleCtx.readShape(worldBoundsStr);
    }

    public SpatialContext newSpatialContext() {
        return new SpatialContext(this);
    }

    public WktShapeParser makeWktShapeParser(SpatialContext ctx) {
        return this.makeClassInstance(this.wktShapeParserClass, ctx, this);
    }

    public BinaryCodec makeBinaryCodec(SpatialContext ctx) {
        return this.makeClassInstance(this.binaryCodecClass, ctx, this);
    }

    private <T> T makeClassInstance(Class<? extends T> clazz, Object ... ctorArgs) {
        try {
            block2: for (Constructor<?> ctor : clazz.getConstructors()) {
                Class<?>[] parameterTypes = ctor.getParameterTypes();
                if (parameterTypes.length != ctorArgs.length) continue;
                for (int i = 0; i < ctorArgs.length; ++i) {
                    Object ctorArg = ctorArgs[i];
                    if (!parameterTypes[i].isAssignableFrom(ctorArg.getClass())) continue block2;
                }
                return clazz.cast(ctor.newInstance(ctorArgs));
            }
        }
        catch (Exception e2) {
            throw new RuntimeException(e2);
        }
        throw new RuntimeException(clazz + " needs a constructor that takes: " + Arrays.toString(ctorArgs));
    }
}

