/*
 * Decompiled with CFR 0.152.
 */
package com.spatial4j.core.io.jts;

import com.spatial4j.core.context.jts.JtsSpatialContext;
import com.spatial4j.core.context.jts.JtsSpatialContextFactory;
import com.spatial4j.core.distance.DistanceUtils;
import com.spatial4j.core.exception.InvalidShapeException;
import com.spatial4j.core.io.jts.JtsWktShapeParser;
import com.spatial4j.core.shape.Shape;
import com.spatial4j.core.shape.jts.JtsPoint;
import com.vividsolutions.jts.geom.CoordinateSequence;
import com.vividsolutions.jts.geom.CoordinateSequenceFilter;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.io.WKTReader;
import java.text.ParseException;

public class JtsWKTReaderShapeParser
extends JtsWktShapeParser {
    public JtsWKTReaderShapeParser(JtsSpatialContext ctx, JtsSpatialContextFactory factory) {
        super(ctx, factory);
    }

    @Override
    public Shape parseIfSupported(String wktString) throws ParseException {
        return this.parseIfSupported(wktString, new WKTReader(this.ctx.getGeometryFactory()));
    }

    protected Shape parseIfSupported(String str2, WKTReader reader) throws ParseException {
        try {
            Geometry geom = reader.read(str2);
            this.checkCoordinates(geom);
            if (geom instanceof Point) {
                Point ptGeom = (Point)geom;
                if (this.ctx.useJtsPoint()) {
                    return new JtsPoint(ptGeom, this.ctx);
                }
                return this.ctx.makePoint(ptGeom.getX(), ptGeom.getY());
            }
            if (geom.isRectangle()) {
                return super.makeRectFromPoly(geom);
            }
            return super.makeShapeFromGeometry(geom);
        }
        catch (InvalidShapeException e2) {
            throw e2;
        }
        catch (Exception e3) {
            throw new InvalidShapeException("error reading WKT: " + e3.toString(), e3);
        }
    }

    protected void checkCoordinates(Geometry geom) {
        geom.apply(new CoordinateSequenceFilter(){
            boolean changed = false;

            public void filter(CoordinateSequence seq2, int i) {
                double xNorm;
                double x = seq2.getX(i);
                double y = seq2.getY(i);
                if (JtsWKTReaderShapeParser.this.ctx.isGeo() && JtsWKTReaderShapeParser.this.ctx.isNormWrapLongitude() && Double.compare(x, xNorm = DistanceUtils.normLonDEG(x)) != 0) {
                    this.changed = true;
                    seq2.setOrdinate(i, 0, xNorm);
                }
                JtsWKTReaderShapeParser.this.ctx.verifyX(x);
                JtsWKTReaderShapeParser.this.ctx.verifyY(y);
            }

            public boolean isDone() {
                return false;
            }

            public boolean isGeometryChanged() {
                return this.changed;
            }
        });
    }
}

