/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.fuseki.async;

import com.hp.hpl.jena.sparql.util.Utils;
import java.util.concurrent.Callable;
import org.apache.jena.atlas.lib.InternalErrorException;
import org.apache.jena.atlas.logging.Log;
import org.apache.jena.fuseki.Fuseki;
import org.apache.jena.fuseki.async.AsyncPool;
import org.apache.jena.fuseki.server.DataService;
import org.slf4j.Logger;

public class AsyncTask
implements Callable<Object> {
    private static Logger log = Fuseki.serverLog;
    private final Callable<Object> callable;
    private final AsyncPool pool;
    private final String displayName;
    private final DataService dataService;
    private String startPoint = null;
    private String finishPoint = null;
    private final String taskId;

    AsyncTask(Callable<Object> callable, AsyncPool pool, String taskId, String displayName, DataService dataService) {
        this.callable = callable;
        this.pool = pool;
        this.taskId = taskId;
        this.displayName = displayName;
        this.dataService = dataService;
    }

    public String getTaskId() {
        return this.taskId;
    }

    public String displayName() {
        return this.displayName;
    }

    public DataService getDataService() {
        return this.dataService;
    }

    private void start() {
        if (this.startPoint != null) {
            String msg = String.format("[Task %s] Async task has already been started", this.taskId);
            Log.warn(Fuseki.serverLog, msg);
            throw new InternalErrorException("Finish has already been called [" + this.getTaskId() + "]");
        }
        Fuseki.serverLog.info(String.format("[Task %s] starts : %s", this.taskId, this.displayName));
        this.startPoint = Utils.nowAsXSDDateTimeString();
    }

    public void finish() {
        if (this.finishPoint != null) {
            String msg = String.format("[Task %s] Async task has already been finished", this.taskId);
            Log.warn(Fuseki.serverLog, msg);
            throw new InternalErrorException("Finish has already been called [" + this.getTaskId() + "]");
        }
        this.finishPoint = Utils.nowAsXSDDateTimeString();
        Fuseki.serverLog.info(String.format("[Task %s] finishes : %s", this.taskId, this.displayName));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object call() {
        try {
            this.start();
            Object object = this.callable.call();
            return object;
        }
        catch (Exception ex) {
            log.error("Async task threw an expection", ex);
            Object var2_3 = null;
            return var2_3;
        }
        finally {
            this.finish();
            this.pool.finished(this);
        }
    }

    public String getStartPoint() {
        return this.startPoint;
    }

    public String getFinishPoint() {
        return this.finishPoint;
    }
}

