/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.fuseki.build;

import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.sparql.util.FmtUtils;
import com.hp.hpl.jena.sparql.util.TypeNotUniqueException;
import com.hp.hpl.jena.sparql.util.graph.GraphUtils;
import java.io.StringReader;
import java.util.HashMap;
import org.apache.jena.fuseki.FusekiConfigException;
import org.apache.jena.fuseki.build.Builder;
import org.apache.jena.fuseki.build.TemplateFunctions;
import org.apache.jena.fuseki.server.DataService;
import org.apache.jena.fuseki.server.FusekiServer;
import org.apache.jena.fuseki.server.FusekiVocab;
import org.apache.jena.riot.Lang;
import org.apache.jena.riot.RDFDataMgr;
import org.apache.jena.riot.RDFLanguages;

public abstract class DataServiceDesc {
    public static DataServiceDesc createFromTemplate(String templateFile, String dbName) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("NAME", dbName);
        FusekiServer.addGlobals(params);
        String template = TemplateFunctions.templateFile(templateFile, params, Lang.TTL);
        Lang lang = RDFLanguages.filenameToLang(templateFile, Lang.TTL);
        StringReader sr = new StringReader(template);
        return DataServiceDesc.create(sr, lang);
    }

    public static DataServiceDesc create(StringReader strReader, Lang lang) {
        Resource root;
        Model model = ModelFactory.createDefaultModel();
        RDFDataMgr.read(model, strReader, "http://base/", lang);
        try {
            root = GraphUtils.findRootByType(model, FusekiVocab.fusekiService);
            if (root == null) {
                throw new FusekiConfigException("No root of type " + FmtUtils.stringForResource(FusekiVocab.fusekiService) + "found");
            }
        }
        catch (TypeNotUniqueException ex) {
            throw new FusekiConfigException("Multiple items of type: " + FusekiVocab.fusekiService);
        }
        return new DataServiceDescResource(root);
    }

    public static DataServiceDesc create(DataService dataService) {
        return new DataServiceDescPrebuilt(dataService);
    }

    public abstract DataService build();

    private static class DataServiceDescPrebuilt
    extends DataServiceDesc {
        private DataService dataService;

        protected DataServiceDescPrebuilt(DataService dataService) {
            this.dataService = dataService;
        }

        @Override
        public DataService build() {
            return this.dataService;
        }
    }

    private static class DataServiceDescResource
    extends DataServiceDesc {
        protected Resource resource;

        protected DataServiceDescResource(Resource resource) {
            this.resource = resource;
        }

        public Resource getResource() {
            return this.resource;
        }

        @Override
        public DataService build() {
            return Builder.buildDataService(this.resource);
        }
    }
}

