/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.fuseki.migrate;

import com.hp.hpl.jena.sparql.core.DatasetGraph;
import com.hp.hpl.jena.sparql.core.DatasetGraphWrapper;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.jena.fuseki.FusekiException;

public class DatasetGraphSwitchable
extends DatasetGraphWrapper {
    private final DatasetGraph dsg1;
    private final DatasetGraph dsg2;
    private final AtomicReference<DatasetGraph> current = new AtomicReference();

    public DatasetGraphSwitchable(DatasetGraph dsg1, DatasetGraph dsg2) {
        super(null);
        if (dsg1 == null) {
            throw new NullPointerException("First argument is null");
        }
        if (dsg2 == null) {
            throw new NullPointerException("Second argument is null");
        }
        this.dsg1 = dsg1;
        this.dsg2 = dsg2;
        this.set(dsg1);
    }

    private void set(DatasetGraph dsg) {
        this.current.set(dsg);
    }

    public void flip() {
        if (this.current.compareAndSet(this.dsg1, this.dsg2)) {
            return;
        }
        if (this.current.compareAndSet(this.dsg2, this.dsg1)) {
            return;
        }
        throw new FusekiException();
    }

    public final DatasetGraph getCurrent() {
        return this.get();
    }

    public final DatasetGraph getDataset1() {
        return this.dsg1;
    }

    public final DatasetGraph getDataset2() {
        return this.dsg2;
    }

    public final void useDataset1() {
        this.set(this.dsg1);
    }

    public final void useDataset2() {
        this.set(this.dsg2);
    }
}

