/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.fuseki.migrate;

import com.hp.hpl.jena.graph.Factory;
import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import org.apache.jena.atlas.web.TypedInputStream;
import org.apache.jena.fuseki.Fuseki;
import org.apache.jena.fuseki.migrate.StreamRDFLimited;
import org.apache.jena.riot.RDFDataMgr;
import org.apache.jena.riot.system.StreamRDF;
import org.apache.jena.riot.system.StreamRDFLib;

public class GraphLoadUtils {
    public static Model readModel(String uri, int limit) {
        Graph g = Factory.createGraphMem();
        GraphLoadUtils.readUtil(g, uri, limit);
        return ModelFactory.createModelForGraph(g);
    }

    public static void loadModel(Model model, String uri, int limit) {
        Graph g = model.getGraph();
        GraphLoadUtils.readUtil(g, uri, limit);
    }

    public static Graph readGraph(String uri, int limit) {
        Graph g = Factory.createGraphMem();
        GraphLoadUtils.readUtil(g, uri, limit);
        return g;
    }

    public static void loadGraph(Graph g, String uri, int limit) {
        GraphLoadUtils.readUtil(g, uri, limit);
    }

    private static void readUtil(Graph graph, String uri, int limit) {
        StreamRDF sink = StreamRDFLib.graph(graph);
        sink = new StreamRDFLimited(sink, limit);
        TypedInputStream input = Fuseki.webStreamManager.open(uri);
        RDFDataMgr.parse(sink, input, uri);
    }
}

